<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\InvoiceType
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CustomerInfo
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public $EArchiveInvoiceInfo;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\NotificationInformation
     */
    public $Notification;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * Constructor method for InvoiceInfo
     * @uses InvoiceInfo::setScenario()
     * @uses InvoiceInfo::setCreateDateUtc()
     * @uses InvoiceInfo::setInvoice()
     * @uses InvoiceInfo::setTargetCustomer()
     * @uses InvoiceInfo::setEArchiveInvoiceInfo()
     * @uses InvoiceInfo::setNotification()
     * @uses InvoiceInfo::setLocalDocumentId()
     * @uses InvoiceInfo::setExtraInformation()
     * @param string $scenario
     * @param string $createDateUtc
     * @param \Novadan\Uyumsoft\StructType\InvoiceType $invoice
     * @param \Novadan\Uyumsoft\StructType\CustomerInfo $targetCustomer
     * @param \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @param \Novadan\Uyumsoft\StructType\NotificationInformation $notification
     * @param string $localDocumentId
     * @param string $extraInformation
     */
    public function __construct($scenario = null, $createDateUtc = null, \Novadan\Uyumsoft\StructType\InvoiceType $invoice = null, \Novadan\Uyumsoft\StructType\CustomerInfo $targetCustomer = null, \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null, \Novadan\Uyumsoft\StructType\NotificationInformation $notification = null, $localDocumentId = null, $extraInformation = null)
    {
        $this
            ->setScenario($scenario)
            ->setCreateDateUtc($createDateUtc)
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setNotification($notification)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation);
    }
    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }
    /**
     * Set Scenario value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioChoosen::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioChoosen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scenario
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceScenarioChoosen::valueIsValid($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceScenarioChoosen', is_array($scenario) ? implode(', ', $scenario) : var_export($scenario, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceScenarioChoosen::getValidValues())), __LINE__);
        }
        $this->Scenario = $scenario;
        return $this;
    }
    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }
    /**
     * Set CreateDateUtc value
     * @param string $createDateUtc
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($createDateUtc) && !is_string($createDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateUtc, true), gettype($createDateUtc)), __LINE__);
        }
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Novadan\Uyumsoft\StructType\InvoiceType|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Novadan\Uyumsoft\StructType\InvoiceType $invoice
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setInvoice(\Novadan\Uyumsoft\StructType\InvoiceType $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get TargetCustomer value
     * @return \Novadan\Uyumsoft\StructType\CustomerInfo|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }
    /**
     * Set TargetCustomer value
     * @param \Novadan\Uyumsoft\StructType\CustomerInfo $targetCustomer
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setTargetCustomer(\Novadan\Uyumsoft\StructType\CustomerInfo $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }
    /**
     * Get EArchiveInvoiceInfo value
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }
    /**
     * Set EArchiveInvoiceInfo value
     * @param \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setEArchiveInvoiceInfo(\Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Novadan\Uyumsoft\StructType\NotificationInformation|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Novadan\Uyumsoft\StructType\NotificationInformation $notification
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setNotification(\Novadan\Uyumsoft\StructType\NotificationInformation $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Novadan\Uyumsoft\StructType\InvoiceInfo
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
}
