<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceExportGtbInformation StructType
 * @subpackage Structs
 */
class InvoiceExportGtbInformation extends AbstractStructBase
{
    /**
     * The RealExportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RealExportDate;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The RefNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNo;
    /**
     * The GcbRegistrationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GcbRegistrationNo;
    /**
     * Constructor method for InvoiceExportGtbInformation
     * @uses InvoiceExportGtbInformation::setRealExportDate()
     * @uses InvoiceExportGtbInformation::setDocumentId()
     * @uses InvoiceExportGtbInformation::setRefNo()
     * @uses InvoiceExportGtbInformation::setGcbRegistrationNo()
     * @param string $realExportDate
     * @param string $documentId
     * @param string $refNo
     * @param string $gcbRegistrationNo
     */
    public function __construct($realExportDate = null, $documentId = null, $refNo = null, $gcbRegistrationNo = null)
    {
        $this
            ->setRealExportDate($realExportDate)
            ->setDocumentId($documentId)
            ->setRefNo($refNo)
            ->setGcbRegistrationNo($gcbRegistrationNo);
    }
    /**
     * Get RealExportDate value
     * @return string
     */
    public function getRealExportDate()
    {
        return $this->RealExportDate;
    }
    /**
     * Set RealExportDate value
     * @param string $realExportDate
     * @return \Novadan\Uyumsoft\StructType\InvoiceExportGtbInformation
     */
    public function setRealExportDate($realExportDate = null)
    {
        // validation for constraint: string
        if (!is_null($realExportDate) && !is_string($realExportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realExportDate, true), gettype($realExportDate)), __LINE__);
        }
        $this->RealExportDate = $realExportDate;
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \Novadan\Uyumsoft\StructType\InvoiceExportGtbInformation
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get RefNo value
     * @return string|null
     */
    public function getRefNo()
    {
        return $this->RefNo;
    }
    /**
     * Set RefNo value
     * @param string $refNo
     * @return \Novadan\Uyumsoft\StructType\InvoiceExportGtbInformation
     */
    public function setRefNo($refNo = null)
    {
        // validation for constraint: string
        if (!is_null($refNo) && !is_string($refNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNo, true), gettype($refNo)), __LINE__);
        }
        $this->RefNo = $refNo;
        return $this;
    }
    /**
     * Get GcbRegistrationNo value
     * @return string|null
     */
    public function getGcbRegistrationNo()
    {
        return $this->GcbRegistrationNo;
    }
    /**
     * Set GcbRegistrationNo value
     * @param string $gcbRegistrationNo
     * @return \Novadan\Uyumsoft\StructType\InvoiceExportGtbInformation
     */
    public function setGcbRegistrationNo($gcbRegistrationNo = null)
    {
        // validation for constraint: string
        if (!is_null($gcbRegistrationNo) && !is_string($gcbRegistrationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gcbRegistrationNo, true), gettype($gcbRegistrationNo)), __LINE__);
        }
        $this->GcbRegistrationNo = $gcbRegistrationNo;
        return $this;
    }
}
