<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceData StructType
 * @subpackage Structs
 */
class InvoiceData extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * Constructor method for InvoiceData
     * @uses InvoiceData::setData()
     * @uses InvoiceData::setLocalDocumentId()
     * @uses InvoiceData::setExtraInformation()
     * @uses InvoiceData::setInvoiceId()
     * @param string $data
     * @param string $localDocumentId
     * @param string $extraInformation
     * @param string $invoiceId
     */
    public function __construct($data = null, $localDocumentId = null, $extraInformation = null, $invoiceId = null)
    {
        $this
            ->setData($data)
            ->setLocalDocumentId($localDocumentId)
            ->setExtraInformation($extraInformation)
            ->setInvoiceId($invoiceId);
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \Novadan\Uyumsoft\StructType\InvoiceData
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Novadan\Uyumsoft\StructType\InvoiceData
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Novadan\Uyumsoft\StructType\InvoiceData
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Novadan\Uyumsoft\StructType\InvoiceData
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
}
