<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q111:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q112:Description
     * @var \Novadan\Uyumsoft\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q113:HazardousRiskIndicator
     * @var \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q114:DeclaredCustomsValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q115:DeclaredForCarriageValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q116:DeclaredStatisticsValueAmount
     * @var \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q117:FreeOnBoardValueAmount
     * @var \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q118:InsuranceValueAmount
     * @var \Novadan\Uyumsoft\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q119:ValueAmount
     * @var \Novadan\Uyumsoft\StructType\ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q120:GrossWeightMeasure
     * @var \Novadan\Uyumsoft\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q121:NetWeightMeasure
     * @var \Novadan\Uyumsoft\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q122:ChargeableWeightMeasure
     * @var \Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q123:GrossVolumeMeasure
     * @var \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q124:NetVolumeMeasure
     * @var \Novadan\Uyumsoft\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q125:Quantity
     * @var \Novadan\Uyumsoft\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q126:RequiredCustomsID
     * @var \Novadan\Uyumsoft\StructType\RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q127:CustomsStatusCode
     * @var \Novadan\Uyumsoft\StructType\CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q128:CustomsTariffQuantity
     * @var \Novadan\Uyumsoft\StructType\CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q129:CustomsImportClassifiedIndicator
     * @var \Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q130:ChargeableQuantity
     * @var \Novadan\Uyumsoft\StructType\ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q131:ReturnableQuantity
     * @var \Novadan\Uyumsoft\StructType\ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q132:TraceID
     * @var \Novadan\Uyumsoft\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for GoodsItemType
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\DescriptionType[] $description
     * @param \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Novadan\Uyumsoft\StructType\ValueAmountType $valueAmount
     * @param \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @param \Novadan\Uyumsoft\StructType\RequiredCustomsIDType $requiredCustomsID
     * @param \Novadan\Uyumsoft\StructType\CustomsStatusCodeType $customsStatusCode
     * @param \Novadan\Uyumsoft\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @param \Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param \Novadan\Uyumsoft\StructType\ChargeableQuantityType $chargeableQuantity
     * @param \Novadan\Uyumsoft\StructType\ReturnableQuantityType $returnableQuantity
     * @param \Novadan\Uyumsoft\StructType\TraceIDType $traceID
     * @param \Novadan\Uyumsoft\StructType\ItemType[] $item
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType[] $invoiceLine
     * @param \Novadan\Uyumsoft\StructType\TemperatureType[] $temperature
     * @param \Novadan\Uyumsoft\StructType\AddressType $originAddress
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, array $description = array(), \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Novadan\Uyumsoft\StructType\ValueAmountType $valueAmount = null, \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure = null, \Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null, \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Novadan\Uyumsoft\StructType\QuantityType $quantity = null, \Novadan\Uyumsoft\StructType\RequiredCustomsIDType $requiredCustomsID = null, \Novadan\Uyumsoft\StructType\CustomsStatusCodeType $customsStatusCode = null, \Novadan\Uyumsoft\StructType\CustomsTariffQuantityType $customsTariffQuantity = null, \Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, \Novadan\Uyumsoft\StructType\ChargeableQuantityType $chargeableQuantity = null, \Novadan\Uyumsoft\StructType\ReturnableQuantityType $returnableQuantity = null, \Novadan\Uyumsoft\StructType\TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), \Novadan\Uyumsoft\StructType\AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return \Novadan\Uyumsoft\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeDescriptionItem instanceof \Novadan\Uyumsoft\StructType\DescriptionType) {
                $invalidValues[] = is_object($goodsItemTypeDescriptionItem) ? get_class($goodsItemTypeDescriptionItem) : sprintf('%s(%s)', gettype($goodsItemTypeDescriptionItem), var_export($goodsItemTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Novadan\Uyumsoft\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DescriptionType[] $description
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DescriptionType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToDescription(\Novadan\Uyumsoft\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \Novadan\Uyumsoft\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setHazardousRiskIndicator(\Novadan\Uyumsoft\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(\Novadan\Uyumsoft\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(\Novadan\Uyumsoft\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(\Novadan\Uyumsoft\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setFreeOnBoardValueAmount(\Novadan\Uyumsoft\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Novadan\Uyumsoft\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setInsuranceValueAmount(\Novadan\Uyumsoft\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \Novadan\Uyumsoft\StructType\ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \Novadan\Uyumsoft\StructType\ValueAmountType $valueAmount
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setValueAmount(\Novadan\Uyumsoft\StructType\ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Novadan\Uyumsoft\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setGrossWeightMeasure(\Novadan\Uyumsoft\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Novadan\Uyumsoft\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setNetWeightMeasure(\Novadan\Uyumsoft\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get ChargeableWeightMeasure value
     * @return \Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }
    /**
     * Set ChargeableWeightMeasure value
     * @param \Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setChargeableWeightMeasure(\Novadan\Uyumsoft\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setGrossVolumeMeasure(\Novadan\Uyumsoft\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Novadan\Uyumsoft\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setNetVolumeMeasure(\Novadan\Uyumsoft\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Novadan\Uyumsoft\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setQuantity(\Novadan\Uyumsoft\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * @return \Novadan\Uyumsoft\StructType\RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }
    /**
     * Set RequiredCustomsID value
     * @param \Novadan\Uyumsoft\StructType\RequiredCustomsIDType $requiredCustomsID
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setRequiredCustomsID(\Novadan\Uyumsoft\StructType\RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * @return \Novadan\Uyumsoft\StructType\CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }
    /**
     * Set CustomsStatusCode value
     * @param \Novadan\Uyumsoft\StructType\CustomsStatusCodeType $customsStatusCode
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setCustomsStatusCode(\Novadan\Uyumsoft\StructType\CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return \Novadan\Uyumsoft\StructType\CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param \Novadan\Uyumsoft\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setCustomsTariffQuantity(\Novadan\Uyumsoft\StructType\CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return \Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param \Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(\Novadan\Uyumsoft\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return \Novadan\Uyumsoft\StructType\ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param \Novadan\Uyumsoft\StructType\ChargeableQuantityType $chargeableQuantity
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setChargeableQuantity(\Novadan\Uyumsoft\StructType\ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return \Novadan\Uyumsoft\StructType\ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param \Novadan\Uyumsoft\StructType\ReturnableQuantityType $returnableQuantity
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setReturnableQuantity(\Novadan\Uyumsoft\StructType\ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Novadan\Uyumsoft\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Novadan\Uyumsoft\StructType\TraceIDType $traceID
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setTraceID(\Novadan\Uyumsoft\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get Item value
     * @return \Novadan\Uyumsoft\StructType\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeItemItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeItemItem instanceof \Novadan\Uyumsoft\StructType\ItemType) {
                $invalidValues[] = is_object($goodsItemTypeItemItem) ? get_class($goodsItemTypeItemItem) : sprintf('%s(%s)', gettype($goodsItemTypeItemItem), var_export($goodsItemTypeItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \Novadan\Uyumsoft\StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemType[] $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToItem(\Novadan\Uyumsoft\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \Novadan\Uyumsoft\StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * @return \Novadan\Uyumsoft\StructType\AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setFreightAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFreightAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeFreightAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeFreightAllowanceChargeItem instanceof \Novadan\Uyumsoft\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($goodsItemTypeFreightAllowanceChargeItem) ? get_class($goodsItemTypeFreightAllowanceChargeItem) : sprintf('%s(%s)', gettype($goodsItemTypeFreightAllowanceChargeItem), var_export($goodsItemTypeFreightAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FreightAllowanceCharge property can only contain items of type \Novadan\Uyumsoft\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($freightAllowanceChargeArrayErrorMessage = self::validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge($freightAllowanceCharge))) {
            throw new \InvalidArgumentException($freightAllowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }
    /**
     * Add item to FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\AllowanceChargeType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToFreightAllowanceCharge(\Novadan\Uyumsoft\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The FreightAllowanceCharge property can only contain items of type \Novadan\Uyumsoft\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Novadan\Uyumsoft\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeInvoiceLineItem instanceof \Novadan\Uyumsoft\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($goodsItemTypeInvoiceLineItem) ? get_class($goodsItemTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($goodsItemTypeInvoiceLineItem), var_export($goodsItemTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType[] $invoiceLine
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\InvoiceLineType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToInvoiceLine(\Novadan\Uyumsoft\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Novadan\Uyumsoft\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \Novadan\Uyumsoft\StructType\TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeTemperatureItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeTemperatureItem instanceof \Novadan\Uyumsoft\StructType\TemperatureType) {
                $invalidValues[] = is_object($goodsItemTypeTemperatureItem) ? get_class($goodsItemTypeTemperatureItem) : sprintf('%s(%s)', gettype($goodsItemTypeTemperatureItem), var_export($goodsItemTypeTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \Novadan\Uyumsoft\StructType\TemperatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Temperature value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TemperatureType[] $temperature
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new \InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\TemperatureType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToTemperature(\Novadan\Uyumsoft\StructType\TemperatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\TemperatureType) {
            throw new \InvalidArgumentException(sprintf('The Temperature property can only contain items of type \Novadan\Uyumsoft\StructType\TemperatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \Novadan\Uyumsoft\StructType\AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \Novadan\Uyumsoft\StructType\AddressType $originAddress
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setOriginAddress(\Novadan\Uyumsoft\StructType\AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeMeasurementDimensionItem instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
                $invalidValues[] = is_object($goodsItemTypeMeasurementDimensionItem) ? get_class($goodsItemTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($goodsItemTypeMeasurementDimensionItem), var_export($goodsItemTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType[] $measurementDimension
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DimensionType $item
     * @return \Novadan\Uyumsoft\StructType\GoodsItemType
     */
    public function addToMeasurementDimension(\Novadan\Uyumsoft\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Novadan\Uyumsoft\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
