<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceInformation StructType
 * @subpackage Structs
 */
class EArchiveInvoiceInformation extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryType;
    /**
     * The NewGenerationPamentRecorderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation
     */
    public $NewGenerationPamentRecorderInfo;
    /**
     * The InternetSalesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\InternetSalesInformation
     */
    public $InternetSalesInfo;
    /**
     * The WithHoldings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation[]
     */
    public $WithHoldings;
    /**
     * Constructor method for EArchiveInvoiceInformation
     * @uses EArchiveInvoiceInformation::setDeliveryType()
     * @uses EArchiveInvoiceInformation::setNewGenerationPamentRecorderInfo()
     * @uses EArchiveInvoiceInformation::setInternetSalesInfo()
     * @uses EArchiveInvoiceInformation::setWithHoldings()
     * @param string $deliveryType
     * @param \Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @param \Novadan\Uyumsoft\StructType\InternetSalesInformation $internetSalesInfo
     * @param \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation[] $withHoldings
     */
    public function __construct($deliveryType = null, \Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null, \Novadan\Uyumsoft\StructType\InternetSalesInformation $internetSalesInfo = null, array $withHoldings = array())
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setNewGenerationPamentRecorderInfo($newGenerationPamentRecorderInfo)
            ->setInternetSalesInfo($internetSalesInfo)
            ->setWithHoldings($withHoldings);
    }
    /**
     * Get DeliveryType value
     * @return string
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceDeliveryType::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceDeliveryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceDeliveryType::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceDeliveryType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceDeliveryType::getValidValues())), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get NewGenerationPamentRecorderInfo value
     * @return \Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation|null
     */
    public function getNewGenerationPamentRecorderInfo()
    {
        return $this->NewGenerationPamentRecorderInfo;
    }
    /**
     * Set NewGenerationPamentRecorderInfo value
     * @param \Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public function setNewGenerationPamentRecorderInfo(\Novadan\Uyumsoft\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null)
    {
        $this->NewGenerationPamentRecorderInfo = $newGenerationPamentRecorderInfo;
        return $this;
    }
    /**
     * Get InternetSalesInfo value
     * @return \Novadan\Uyumsoft\StructType\InternetSalesInformation|null
     */
    public function getInternetSalesInfo()
    {
        return $this->InternetSalesInfo;
    }
    /**
     * Set InternetSalesInfo value
     * @param \Novadan\Uyumsoft\StructType\InternetSalesInformation $internetSalesInfo
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public function setInternetSalesInfo(\Novadan\Uyumsoft\StructType\InternetSalesInformation $internetSalesInfo = null)
    {
        $this->InternetSalesInfo = $internetSalesInfo;
        return $this;
    }
    /**
     * Get WithHoldings value
     * @return \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation[]|null
     */
    public function getWithHoldings()
    {
        return $this->WithHoldings;
    }
    /**
     * This method is responsible for validating the values passed to the setWithHoldings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithHoldings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithHoldingsForArrayConstraintsFromSetWithHoldings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eArchiveInvoiceInformationWithHoldingsItem) {
            // validation for constraint: itemType
            if (!$eArchiveInvoiceInformationWithHoldingsItem instanceof \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation) {
                $invalidValues[] = is_object($eArchiveInvoiceInformationWithHoldingsItem) ? get_class($eArchiveInvoiceInformationWithHoldingsItem) : sprintf('%s(%s)', gettype($eArchiveInvoiceInformationWithHoldingsItem), var_export($eArchiveInvoiceInformationWithHoldingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithHoldings property can only contain items of type \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation[] $withHoldings
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public function setWithHoldings(array $withHoldings = array())
    {
        // validation for constraint: array
        if ('' !== ($withHoldingsArrayErrorMessage = self::validateWithHoldingsForArrayConstraintsFromSetWithHoldings($withHoldings))) {
            throw new \InvalidArgumentException($withHoldingsArrayErrorMessage, __LINE__);
        }
        $this->WithHoldings = $withHoldings;
        return $this;
    }
    /**
     * Add item to WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation $item
     * @return \Novadan\Uyumsoft\StructType\EArchiveInvoiceInformation
     */
    public function addToWithHoldings(\Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation) {
            throw new \InvalidArgumentException(sprintf('The WithHoldings property can only contain items of type \Novadan\Uyumsoft\StructType\EArchiveWithHoldingInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithHoldings[] = $item;
        return $this;
    }
}
