<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveCancelInvoiceContext StructType
 * @subpackage Structs
 */
class EArchiveCancelInvoiceContext extends AbstractStructBase
{
    /**
     * The CancelDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CancelDate;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * Constructor method for EArchiveCancelInvoiceContext
     * @uses EArchiveCancelInvoiceContext::setCancelDate()
     * @uses EArchiveCancelInvoiceContext::setInvoiceId()
     * @param string $cancelDate
     * @param string $invoiceId
     */
    public function __construct($cancelDate = null, $invoiceId = null)
    {
        $this
            ->setCancelDate($cancelDate)
            ->setInvoiceId($invoiceId);
    }
    /**
     * Get CancelDate value
     * @return string
     */
    public function getCancelDate()
    {
        return $this->CancelDate;
    }
    /**
     * Set CancelDate value
     * @param string $cancelDate
     * @return \Novadan\Uyumsoft\StructType\EArchiveCancelInvoiceContext
     */
    public function setCancelDate($cancelDate = null)
    {
        // validation for constraint: string
        if (!is_null($cancelDate) && !is_string($cancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelDate, true), gettype($cancelDate)), __LINE__);
        }
        $this->CancelDate = $cancelDate;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Novadan\Uyumsoft\StructType\EArchiveCancelInvoiceContext
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
}
