<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentResponseStatusInfo StructType
 * @subpackage Structs
 */
class DocumentResponseStatusInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for DocumentResponseStatusInfo
     * @uses DocumentResponseStatusInfo::setStatus()
     * @uses DocumentResponseStatusInfo::setStatusCode()
     * @uses DocumentResponseStatusInfo::setInvoiceId()
     * @uses DocumentResponseStatusInfo::setMessage()
     * @param string $status
     * @param int $statusCode
     * @param string $invoiceId
     * @param string $message
     */
    public function __construct($status = null, $statusCode = null, $invoiceId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setInvoiceId($invoiceId)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Novadan\Uyumsoft\EnumType\DocumentResponseEntityStatus::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\DocumentResponseEntityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseStatusInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\DocumentResponseEntityStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\DocumentResponseEntityStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Novadan\Uyumsoft\EnumType\DocumentResponseEntityStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseStatusInfo
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseStatusInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Novadan\Uyumsoft\StructType\DocumentResponseStatusInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
