<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyBaseEntity StructType
 * @subpackage Structs
 */
class CompanyBaseEntity extends EntityUpdatedHistory
{
    /**
     * The FiscalYearMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FiscalYearMonth;
    /**
     * The PhoneTypeEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PhoneTypeEnum;
    /**
     * The LedgerStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LedgerStartDate;
    /**
     * The LedgerMasterCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LedgerMasterCounter;
    /**
     * The LedgerDetailCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LedgerDetailCounter;
    /**
     * The LedgerDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LedgerDocumentId;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The BranchNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchNo;
    /**
     * The BusinessDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessDescription;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for CompanyBaseEntity
     * @uses CompanyBaseEntity::setFiscalYearMonth()
     * @uses CompanyBaseEntity::setPhoneTypeEnum()
     * @uses CompanyBaseEntity::setLedgerStartDate()
     * @uses CompanyBaseEntity::setLedgerMasterCounter()
     * @uses CompanyBaseEntity::setLedgerDetailCounter()
     * @uses CompanyBaseEntity::setLedgerDocumentId()
     * @uses CompanyBaseEntity::setBranchName()
     * @uses CompanyBaseEntity::setBranchNo()
     * @uses CompanyBaseEntity::setBusinessDescription()
     * @uses CompanyBaseEntity::setEmail()
     * @uses CompanyBaseEntity::setFaxNumber()
     * @uses CompanyBaseEntity::setPhoneNumber()
     * @param int $fiscalYearMonth
     * @param string $phoneTypeEnum
     * @param string $ledgerStartDate
     * @param int $ledgerMasterCounter
     * @param int $ledgerDetailCounter
     * @param int $ledgerDocumentId
     * @param string $branchName
     * @param string $branchNo
     * @param string $businessDescription
     * @param string $email
     * @param string $faxNumber
     * @param string $phoneNumber
     */
    public function __construct($fiscalYearMonth = null, $phoneTypeEnum = null, $ledgerStartDate = null, $ledgerMasterCounter = null, $ledgerDetailCounter = null, $ledgerDocumentId = null, $branchName = null, $branchNo = null, $businessDescription = null, $email = null, $faxNumber = null, $phoneNumber = null)
    {
        $this
            ->setFiscalYearMonth($fiscalYearMonth)
            ->setPhoneTypeEnum($phoneTypeEnum)
            ->setLedgerStartDate($ledgerStartDate)
            ->setLedgerMasterCounter($ledgerMasterCounter)
            ->setLedgerDetailCounter($ledgerDetailCounter)
            ->setLedgerDocumentId($ledgerDocumentId)
            ->setBranchName($branchName)
            ->setBranchNo($branchNo)
            ->setBusinessDescription($businessDescription)
            ->setEmail($email)
            ->setFaxNumber($faxNumber)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get FiscalYearMonth value
     * @return int
     */
    public function getFiscalYearMonth()
    {
        return $this->FiscalYearMonth;
    }
    /**
     * Set FiscalYearMonth value
     * @param int $fiscalYearMonth
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setFiscalYearMonth($fiscalYearMonth = null)
    {
        // validation for constraint: int
        if (!is_null($fiscalYearMonth) && !(is_int($fiscalYearMonth) || ctype_digit($fiscalYearMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fiscalYearMonth, true), gettype($fiscalYearMonth)), __LINE__);
        }
        $this->FiscalYearMonth = $fiscalYearMonth;
        return $this;
    }
    /**
     * Get PhoneTypeEnum value
     * @return string
     */
    public function getPhoneTypeEnum()
    {
        return $this->PhoneTypeEnum;
    }
    /**
     * Set PhoneTypeEnum value
     * @uses \Novadan\Uyumsoft\EnumType\PhoneType::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\PhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneTypeEnum
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setPhoneTypeEnum($phoneTypeEnum = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\PhoneType::valueIsValid($phoneTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\PhoneType', is_array($phoneTypeEnum) ? implode(', ', $phoneTypeEnum) : var_export($phoneTypeEnum, true), implode(', ', \Novadan\Uyumsoft\EnumType\PhoneType::getValidValues())), __LINE__);
        }
        $this->PhoneTypeEnum = $phoneTypeEnum;
        return $this;
    }
    /**
     * Get LedgerStartDate value
     * @return string
     */
    public function getLedgerStartDate()
    {
        return $this->LedgerStartDate;
    }
    /**
     * Set LedgerStartDate value
     * @param string $ledgerStartDate
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setLedgerStartDate($ledgerStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerStartDate) && !is_string($ledgerStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerStartDate, true), gettype($ledgerStartDate)), __LINE__);
        }
        $this->LedgerStartDate = $ledgerStartDate;
        return $this;
    }
    /**
     * Get LedgerMasterCounter value
     * @return int
     */
    public function getLedgerMasterCounter()
    {
        return $this->LedgerMasterCounter;
    }
    /**
     * Set LedgerMasterCounter value
     * @param int $ledgerMasterCounter
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setLedgerMasterCounter($ledgerMasterCounter = null)
    {
        // validation for constraint: int
        if (!is_null($ledgerMasterCounter) && !(is_int($ledgerMasterCounter) || ctype_digit($ledgerMasterCounter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ledgerMasterCounter, true), gettype($ledgerMasterCounter)), __LINE__);
        }
        $this->LedgerMasterCounter = $ledgerMasterCounter;
        return $this;
    }
    /**
     * Get LedgerDetailCounter value
     * @return int
     */
    public function getLedgerDetailCounter()
    {
        return $this->LedgerDetailCounter;
    }
    /**
     * Set LedgerDetailCounter value
     * @param int $ledgerDetailCounter
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setLedgerDetailCounter($ledgerDetailCounter = null)
    {
        // validation for constraint: int
        if (!is_null($ledgerDetailCounter) && !(is_int($ledgerDetailCounter) || ctype_digit($ledgerDetailCounter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ledgerDetailCounter, true), gettype($ledgerDetailCounter)), __LINE__);
        }
        $this->LedgerDetailCounter = $ledgerDetailCounter;
        return $this;
    }
    /**
     * Get LedgerDocumentId value
     * @return int
     */
    public function getLedgerDocumentId()
    {
        return $this->LedgerDocumentId;
    }
    /**
     * Set LedgerDocumentId value
     * @param int $ledgerDocumentId
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setLedgerDocumentId($ledgerDocumentId = null)
    {
        // validation for constraint: int
        if (!is_null($ledgerDocumentId) && !(is_int($ledgerDocumentId) || ctype_digit($ledgerDocumentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ledgerDocumentId, true), gettype($ledgerDocumentId)), __LINE__);
        }
        $this->LedgerDocumentId = $ledgerDocumentId;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get BranchNo value
     * @return string|null
     */
    public function getBranchNo()
    {
        return $this->BranchNo;
    }
    /**
     * Set BranchNo value
     * @param string $branchNo
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setBranchNo($branchNo = null)
    {
        // validation for constraint: string
        if (!is_null($branchNo) && !is_string($branchNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchNo, true), gettype($branchNo)), __LINE__);
        }
        $this->BranchNo = $branchNo;
        return $this;
    }
    /**
     * Get BusinessDescription value
     * @return string|null
     */
    public function getBusinessDescription()
    {
        return $this->BusinessDescription;
    }
    /**
     * Set BusinessDescription value
     * @param string $businessDescription
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setBusinessDescription($businessDescription = null)
    {
        // validation for constraint: string
        if (!is_null($businessDescription) && !is_string($businessDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDescription, true), gettype($businessDescription)), __LINE__);
        }
        $this->BusinessDescription = $businessDescription;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \Novadan\Uyumsoft\StructType\CompanyBaseEntity
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
}
