<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeInvoiceArchiveStatus StructType
 * @subpackage Structs
 */
class ChangeInvoiceArchiveStatus extends AbstractStructBase
{
    /**
     * The isInbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isInbox;
    /**
     * The isArchived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isArchived;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\UserInformation
     */
    public $userInfo;
    /**
     * The invoiceIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\ArrayType\ArrayOfString
     */
    public $invoiceIds;
    /**
     * Constructor method for ChangeInvoiceArchiveStatus
     * @uses ChangeInvoiceArchiveStatus::setIsInbox()
     * @uses ChangeInvoiceArchiveStatus::setIsArchived()
     * @uses ChangeInvoiceArchiveStatus::setUserInfo()
     * @uses ChangeInvoiceArchiveStatus::setInvoiceIds()
     * @param bool $isInbox
     * @param bool $isArchived
     * @param \Novadan\Uyumsoft\StructType\UserInformation $userInfo
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfString $invoiceIds
     */
    public function __construct($isInbox = null, $isArchived = null, \Novadan\Uyumsoft\StructType\UserInformation $userInfo = null, \Novadan\Uyumsoft\ArrayType\ArrayOfString $invoiceIds = null)
    {
        $this
            ->setIsInbox($isInbox)
            ->setIsArchived($isArchived)
            ->setUserInfo($userInfo)
            ->setInvoiceIds($invoiceIds);
    }
    /**
     * Get isInbox value
     * @return bool
     */
    public function getIsInbox()
    {
        return $this->isInbox;
    }
    /**
     * Set isInbox value
     * @param bool $isInbox
     * @return \Novadan\Uyumsoft\StructType\ChangeInvoiceArchiveStatus
     */
    public function setIsInbox($isInbox = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInbox) && !is_bool($isInbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInbox, true), gettype($isInbox)), __LINE__);
        }
        $this->isInbox = $isInbox;
        return $this;
    }
    /**
     * Get isArchived value
     * @return bool
     */
    public function getIsArchived()
    {
        return $this->isArchived;
    }
    /**
     * Set isArchived value
     * @param bool $isArchived
     * @return \Novadan\Uyumsoft\StructType\ChangeInvoiceArchiveStatus
     */
    public function setIsArchived($isArchived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchived) && !is_bool($isArchived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArchived, true), gettype($isArchived)), __LINE__);
        }
        $this->isArchived = $isArchived;
        return $this;
    }
    /**
     * Get userInfo value
     * @return \Novadan\Uyumsoft\StructType\UserInformation|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Novadan\Uyumsoft\StructType\UserInformation $userInfo
     * @return \Novadan\Uyumsoft\StructType\ChangeInvoiceArchiveStatus
     */
    public function setUserInfo(\Novadan\Uyumsoft\StructType\UserInformation $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get invoiceIds value
     * @return \Novadan\Uyumsoft\ArrayType\ArrayOfString|null
     */
    public function getInvoiceIds()
    {
        return $this->invoiceIds;
    }
    /**
     * Set invoiceIds value
     * @param \Novadan\Uyumsoft\ArrayType\ArrayOfString $invoiceIds
     * @return \Novadan\Uyumsoft\StructType\ChangeInvoiceArchiveStatus
     */
    public function setInvoiceIds(\Novadan\Uyumsoft\ArrayType\ArrayOfString $invoiceIds = null)
    {
        $this->invoiceIds = $invoiceIds;
        return $this;
    }
}
