<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Who ServiceType
 * @subpackage Services
 */
class Who extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WhoAmI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\WhoAmI $parameters
     * @return \Novadan\Uyumsoft\StructType\WhoAmIResponse|bool
     */
    public function WhoAmI(\Novadan\Uyumsoft\StructType\WhoAmI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WhoAmI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\WhoAmIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
