<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Queue ServiceType
 * @subpackage Services
 */
class Queue extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueueInvoiceNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\QueueInvoiceNotification $parameters
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationResponse|bool
     */
    public function QueueInvoiceNotification(\Novadan\Uyumsoft\StructType\QueueInvoiceNotification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueueInvoiceNotification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\QueueInvoiceNotificationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
