<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportExistingInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\ImportExistingInvoice $parameters
     * @return \Novadan\Uyumsoft\StructType\ImportExistingInvoiceResponse|bool
     */
    public function ImportExistingInvoice(\Novadan\Uyumsoft\StructType\ImportExistingInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportExistingInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\ImportExistingInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
