<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Compressed ServiceType
 * @subpackage Services
 */
class Compressed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CompressedSaveAsDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\CompressedSaveAsDraft $parameters
     * @return \Novadan\Uyumsoft\StructType\CompressedSaveAsDraftResponse|bool
     */
    public function CompressedSaveAsDraft(\Novadan\Uyumsoft\StructType\CompressedSaveAsDraft $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CompressedSaveAsDraft($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CompressedSendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\CompressedSendInvoice $parameters
     * @return \Novadan\Uyumsoft\StructType\CompressedSendInvoiceResponse|bool
     */
    public function CompressedSendInvoice(\Novadan\Uyumsoft\StructType\CompressedSendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CompressedSendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\CompressedSaveAsDraftResponse|\Novadan\Uyumsoft\StructType\CompressedSendInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
