<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q243:Note
     * @var \Novadan\Uyumsoft\StructType\NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q244:PenaltySurchargePercent
     * @var \Novadan\Uyumsoft\StructType\PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q245:Amount
     * @var \Novadan\Uyumsoft\StructType\AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q246:PenaltyAmount
     * @var \Novadan\Uyumsoft\StructType\PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q247:PaymentDueDate
     * @var \Novadan\Uyumsoft\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTermsType
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     * @param \Novadan\Uyumsoft\StructType\NoteType $note
     * @param \Novadan\Uyumsoft\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @param \Novadan\Uyumsoft\StructType\AmountType $amount
     * @param \Novadan\Uyumsoft\StructType\PenaltyAmountType $penaltyAmount
     * @param \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate
     * @param \Novadan\Uyumsoft\StructType\PeriodType $settlementPeriod
     */
    public function __construct(\Novadan\Uyumsoft\StructType\NoteType $note = null, \Novadan\Uyumsoft\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null, \Novadan\Uyumsoft\StructType\AmountType $amount = null, \Novadan\Uyumsoft\StructType\PenaltyAmountType $penaltyAmount = null, \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate = null, \Novadan\Uyumsoft\StructType\PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Note value
     * @return \Novadan\Uyumsoft\StructType\NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Novadan\Uyumsoft\StructType\NoteType $note
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setNote(\Novadan\Uyumsoft\StructType\NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return \Novadan\Uyumsoft\StructType\PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param \Novadan\Uyumsoft\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setPenaltySurchargePercent(\Novadan\Uyumsoft\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Novadan\Uyumsoft\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Novadan\Uyumsoft\StructType\AmountType $amount
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setAmount(\Novadan\Uyumsoft\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return \Novadan\Uyumsoft\StructType\PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param \Novadan\Uyumsoft\StructType\PenaltyAmountType $penaltyAmount
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setPenaltyAmount(\Novadan\Uyumsoft\StructType\PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Novadan\Uyumsoft\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setPaymentDueDate(\Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }
    /**
     * Set SettlementPeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $settlementPeriod
     * @return \Novadan\Uyumsoft\StructType\PaymentTermsType
     */
    public function setSettlementPeriod(\Novadan\Uyumsoft\StructType\PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
}
