<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeansType StructType
 * @subpackage Structs
 */
class PaymentMeansType extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q239:PaymentMeansCode
     * @var \Novadan\Uyumsoft\StructType\PaymentMeansCodeType
     */
    public $PaymentMeansCode;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q240:PaymentDueDate
     * @var \Novadan\Uyumsoft\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q241:PaymentChannelCode
     * @var \Novadan\Uyumsoft\StructType\PaymentChannelCodeType
     */
    public $PaymentChannelCode;
    /**
     * The InstructionNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q242:InstructionNote
     * @var \Novadan\Uyumsoft\StructType\InstructionNoteType
     */
    public $InstructionNote;
    /**
     * The PayerFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\FinancialAccountType
     */
    public $PayerFinancialAccount;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\FinancialAccountType
     */
    public $PayeeFinancialAccount;
    /**
     * Constructor method for PaymentMeansType
     * @uses PaymentMeansType::setPaymentMeansCode()
     * @uses PaymentMeansType::setPaymentDueDate()
     * @uses PaymentMeansType::setPaymentChannelCode()
     * @uses PaymentMeansType::setInstructionNote()
     * @uses PaymentMeansType::setPayerFinancialAccount()
     * @uses PaymentMeansType::setPayeeFinancialAccount()
     * @param \Novadan\Uyumsoft\StructType\PaymentMeansCodeType $paymentMeansCode
     * @param \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate
     * @param \Novadan\Uyumsoft\StructType\PaymentChannelCodeType $paymentChannelCode
     * @param \Novadan\Uyumsoft\StructType\InstructionNoteType $instructionNote
     * @param \Novadan\Uyumsoft\StructType\FinancialAccountType $payerFinancialAccount
     * @param \Novadan\Uyumsoft\StructType\FinancialAccountType $payeeFinancialAccount
     */
    public function __construct(\Novadan\Uyumsoft\StructType\PaymentMeansCodeType $paymentMeansCode = null, \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate = null, \Novadan\Uyumsoft\StructType\PaymentChannelCodeType $paymentChannelCode = null, \Novadan\Uyumsoft\StructType\InstructionNoteType $instructionNote = null, \Novadan\Uyumsoft\StructType\FinancialAccountType $payerFinancialAccount = null, \Novadan\Uyumsoft\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setInstructionNote($instructionNote)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPayeeFinancialAccount($payeeFinancialAccount);
    }
    /**
     * Get PaymentMeansCode value
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansCodeType|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }
    /**
     * Set PaymentMeansCode value
     * @param \Novadan\Uyumsoft\StructType\PaymentMeansCodeType $paymentMeansCode
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setPaymentMeansCode(\Novadan\Uyumsoft\StructType\PaymentMeansCodeType $paymentMeansCode = null)
    {
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Novadan\Uyumsoft\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setPaymentDueDate(\Novadan\Uyumsoft\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get PaymentChannelCode value
     * @return \Novadan\Uyumsoft\StructType\PaymentChannelCodeType|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }
    /**
     * Set PaymentChannelCode value
     * @param \Novadan\Uyumsoft\StructType\PaymentChannelCodeType $paymentChannelCode
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setPaymentChannelCode(\Novadan\Uyumsoft\StructType\PaymentChannelCodeType $paymentChannelCode = null)
    {
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }
    /**
     * Get InstructionNote value
     * @return \Novadan\Uyumsoft\StructType\InstructionNoteType|null
     */
    public function getInstructionNote()
    {
        return $this->InstructionNote;
    }
    /**
     * Set InstructionNote value
     * @param \Novadan\Uyumsoft\StructType\InstructionNoteType $instructionNote
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setInstructionNote(\Novadan\Uyumsoft\StructType\InstructionNoteType $instructionNote = null)
    {
        $this->InstructionNote = $instructionNote;
        return $this;
    }
    /**
     * Get PayerFinancialAccount value
     * @return \Novadan\Uyumsoft\StructType\FinancialAccountType|null
     */
    public function getPayerFinancialAccount()
    {
        return $this->PayerFinancialAccount;
    }
    /**
     * Set PayerFinancialAccount value
     * @param \Novadan\Uyumsoft\StructType\FinancialAccountType $payerFinancialAccount
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setPayerFinancialAccount(\Novadan\Uyumsoft\StructType\FinancialAccountType $payerFinancialAccount = null)
    {
        $this->PayerFinancialAccount = $payerFinancialAccount;
        return $this;
    }
    /**
     * Get PayeeFinancialAccount value
     * @return \Novadan\Uyumsoft\StructType\FinancialAccountType|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }
    /**
     * Set PayeeFinancialAccount value
     * @param \Novadan\Uyumsoft\StructType\FinancialAccountType $payeeFinancialAccount
     * @return \Novadan\Uyumsoft\StructType\PaymentMeansType
     */
    public function setPayeeFinancialAccount(\Novadan\Uyumsoft\StructType\FinancialAccountType $payeeFinancialAccount = null)
    {
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
}
