<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q18:WebsiteURI
     * @var \Novadan\Uyumsoft\StructType\WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q19:EndpointID
     * @var \Novadan\Uyumsoft\StructType\EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q20:IndustryClassificationCode
     * @var \Novadan\Uyumsoft\StructType\IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $AgentParty;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     * @param \Novadan\Uyumsoft\StructType\WebsiteURIType $websiteURI
     * @param \Novadan\Uyumsoft\StructType\EndpointIDType $endpointID
     * @param \Novadan\Uyumsoft\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @param \Novadan\Uyumsoft\StructType\PartyIdentificationType[] $partyIdentification
     * @param \Novadan\Uyumsoft\StructType\PartyNameType $partyName
     * @param \Novadan\Uyumsoft\StructType\AddressType $postalAddress
     * @param \Novadan\Uyumsoft\StructType\LocationType $physicalLocation
     * @param \Novadan\Uyumsoft\StructType\PartyTaxSchemeType $partyTaxScheme
     * @param \Novadan\Uyumsoft\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @param \Novadan\Uyumsoft\StructType\ContactType $contact
     * @param \Novadan\Uyumsoft\StructType\PersonType $person
     * @param \Novadan\Uyumsoft\StructType\PartyType $agentParty
     */
    public function __construct(\Novadan\Uyumsoft\StructType\WebsiteURIType $websiteURI = null, \Novadan\Uyumsoft\StructType\EndpointIDType $endpointID = null, \Novadan\Uyumsoft\StructType\IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), \Novadan\Uyumsoft\StructType\PartyNameType $partyName = null, \Novadan\Uyumsoft\StructType\AddressType $postalAddress = null, \Novadan\Uyumsoft\StructType\LocationType $physicalLocation = null, \Novadan\Uyumsoft\StructType\PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), \Novadan\Uyumsoft\StructType\ContactType $contact = null, \Novadan\Uyumsoft\StructType\PersonType $person = null, \Novadan\Uyumsoft\StructType\PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }
    /**
     * Get WebsiteURI value
     * @return \Novadan\Uyumsoft\StructType\WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }
    /**
     * Set WebsiteURI value
     * @param \Novadan\Uyumsoft\StructType\WebsiteURIType $websiteURI
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setWebsiteURI(\Novadan\Uyumsoft\StructType\WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }
    /**
     * Get EndpointID value
     * @return \Novadan\Uyumsoft\StructType\EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }
    /**
     * Set EndpointID value
     * @param \Novadan\Uyumsoft\StructType\EndpointIDType $endpointID
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setEndpointID(\Novadan\Uyumsoft\StructType\EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * @return \Novadan\Uyumsoft\StructType\IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }
    /**
     * Set IndustryClassificationCode value
     * @param \Novadan\Uyumsoft\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setIndustryClassificationCode(\Novadan\Uyumsoft\StructType\IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }
    /**
     * Get PartyIdentification value
     * @return \Novadan\Uyumsoft\StructType\PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyIdentificationItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyIdentificationItem instanceof \Novadan\Uyumsoft\StructType\PartyIdentificationType) {
                $invalidValues[] = is_object($partyTypePartyIdentificationItem) ? get_class($partyTypePartyIdentificationItem) : sprintf('%s(%s)', gettype($partyTypePartyIdentificationItem), var_export($partyTypePartyIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyIdentification property can only contain items of type \Novadan\Uyumsoft\StructType\PartyIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PartyIdentificationType[] $partyIdentification
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($partyIdentificationArrayErrorMessage = self::validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification($partyIdentification))) {
            throw new \InvalidArgumentException($partyIdentificationArrayErrorMessage, __LINE__);
        }
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }
    /**
     * Add item to PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PartyIdentificationType $item
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function addToPartyIdentification(\Novadan\Uyumsoft\StructType\PartyIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PartyIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The PartyIdentification property can only contain items of type \Novadan\Uyumsoft\StructType\PartyIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyIdentification[] = $item;
        return $this;
    }
    /**
     * Get PartyName value
     * @return \Novadan\Uyumsoft\StructType\PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }
    /**
     * Set PartyName value
     * @param \Novadan\Uyumsoft\StructType\PartyNameType $partyName
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPartyName(\Novadan\Uyumsoft\StructType\PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \Novadan\Uyumsoft\StructType\AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \Novadan\Uyumsoft\StructType\AddressType $postalAddress
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPostalAddress(\Novadan\Uyumsoft\StructType\AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \Novadan\Uyumsoft\StructType\LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }
    /**
     * Set PhysicalLocation value
     * @param \Novadan\Uyumsoft\StructType\LocationType $physicalLocation
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPhysicalLocation(\Novadan\Uyumsoft\StructType\LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }
    /**
     * Get PartyTaxScheme value
     * @return \Novadan\Uyumsoft\StructType\PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }
    /**
     * Set PartyTaxScheme value
     * @param \Novadan\Uyumsoft\StructType\PartyTaxSchemeType $partyTaxScheme
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPartyTaxScheme(\Novadan\Uyumsoft\StructType\PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * @return \Novadan\Uyumsoft\StructType\PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyLegalEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyLegalEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyLegalEntityItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyLegalEntityItem instanceof \Novadan\Uyumsoft\StructType\PartyLegalEntityType) {
                $invalidValues[] = is_object($partyTypePartyLegalEntityItem) ? get_class($partyTypePartyLegalEntityItem) : sprintf('%s(%s)', gettype($partyTypePartyLegalEntityItem), var_export($partyTypePartyLegalEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyLegalEntity property can only contain items of type \Novadan\Uyumsoft\StructType\PartyLegalEntityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($partyLegalEntityArrayErrorMessage = self::validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity($partyLegalEntity))) {
            throw new \InvalidArgumentException($partyLegalEntityArrayErrorMessage, __LINE__);
        }
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\PartyLegalEntityType $item
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function addToPartyLegalEntity(\Novadan\Uyumsoft\StructType\PartyLegalEntityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\PartyLegalEntityType) {
            throw new \InvalidArgumentException(sprintf('The PartyLegalEntity property can only contain items of type \Novadan\Uyumsoft\StructType\PartyLegalEntityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Novadan\Uyumsoft\StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Novadan\Uyumsoft\StructType\ContactType $contact
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setContact(\Novadan\Uyumsoft\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Person value
     * @return \Novadan\Uyumsoft\StructType\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \Novadan\Uyumsoft\StructType\PersonType $person
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setPerson(\Novadan\Uyumsoft\StructType\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $agentParty
     * @return \Novadan\Uyumsoft\StructType\PartyType
     */
    public function setAgentParty(\Novadan\Uyumsoft\StructType\PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
}
