<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedResponseOfSystemUser StructType
 * @subpackage Structs
 */
class PagedResponseOfSystemUser extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalCount;
    /**
     * The TotalPages
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\SystemUser[]
     */
    public $Items;
    /**
     * Constructor method for PagedResponseOfSystemUser
     * @uses PagedResponseOfSystemUser::setPageIndex()
     * @uses PagedResponseOfSystemUser::setPageSize()
     * @uses PagedResponseOfSystemUser::setTotalCount()
     * @uses PagedResponseOfSystemUser::setTotalPages()
     * @uses PagedResponseOfSystemUser::setItems()
     * @param int $pageIndex
     * @param int $pageSize
     * @param int $totalCount
     * @param int $totalPages
     * @param \Novadan\Uyumsoft\StructType\SystemUser[] $items
     */
    public function __construct($pageIndex = null, $pageSize = null, $totalCount = null, $totalPages = null, array $items = array())
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setTotalCount($totalCount)
            ->setTotalPages($totalPages)
            ->setItems($items);
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get TotalCount value
     * @return int
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }
    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->TotalCount = $totalCount;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get Items value
     * @return \Novadan\Uyumsoft\StructType\SystemUser[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagedResponseOfSystemUserItemsItem) {
            // validation for constraint: itemType
            if (!$pagedResponseOfSystemUserItemsItem instanceof \Novadan\Uyumsoft\StructType\SystemUser) {
                $invalidValues[] = is_object($pagedResponseOfSystemUserItemsItem) ? get_class($pagedResponseOfSystemUserItemsItem) : sprintf('%s(%s)', gettype($pagedResponseOfSystemUserItemsItem), var_export($pagedResponseOfSystemUserItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Items property can only contain items of type \Novadan\Uyumsoft\StructType\SystemUser, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Items value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SystemUser[] $items
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->Items = $items;
        return $this;
    }
    /**
     * Add item to Items value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\SystemUser $item
     * @return \Novadan\Uyumsoft\StructType\PagedResponseOfSystemUser
     */
    public function addToItems(\Novadan\Uyumsoft\StructType\SystemUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\SystemUser) {
            throw new \InvalidArgumentException(sprintf('The Items property can only contain items of type \Novadan\Uyumsoft\StructType\SystemUser, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Items[] = $item;
        return $this;
    }
}
