<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedQueryContext StructType
 * @subpackage Structs
 */
class PagedQueryContext extends AbstractStructBase
{
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * Constructor method for PagedQueryContext
     * @uses PagedQueryContext::setPageIndex()
     * @uses PagedQueryContext::setPageSize()
     * @param int $pageIndex
     * @param int $pageSize
     */
    public function __construct($pageIndex = null, $pageSize = null)
    {
        $this
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize);
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \Novadan\Uyumsoft\StructType\PagedQueryContext
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \Novadan\Uyumsoft\StructType\PagedQueryContext
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
}
