<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q252:LineExtensionAmount
     * @var \Novadan\Uyumsoft\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q253:TaxExclusiveAmount
     * @var \Novadan\Uyumsoft\StructType\TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q254:TaxInclusiveAmount
     * @var \Novadan\Uyumsoft\StructType\TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q255:AllowanceTotalAmount
     * @var \Novadan\Uyumsoft\StructType\AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q256:ChargeTotalAmount
     * @var \Novadan\Uyumsoft\StructType\ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q257:PayableRoundingAmount
     * @var \Novadan\Uyumsoft\StructType\PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q258:PayableAmount
     * @var \Novadan\Uyumsoft\StructType\PayableAmountType
     */
    public $PayableAmount;
    /**
     * Constructor method for MonetaryTotalType
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     * @param \Novadan\Uyumsoft\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \Novadan\Uyumsoft\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @param \Novadan\Uyumsoft\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @param \Novadan\Uyumsoft\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @param \Novadan\Uyumsoft\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @param \Novadan\Uyumsoft\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @param \Novadan\Uyumsoft\StructType\PayableAmountType $payableAmount
     */
    public function __construct(\Novadan\Uyumsoft\StructType\LineExtensionAmountType $lineExtensionAmount = null, \Novadan\Uyumsoft\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null, \Novadan\Uyumsoft\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null, \Novadan\Uyumsoft\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null, \Novadan\Uyumsoft\StructType\ChargeTotalAmountType $chargeTotalAmount = null, \Novadan\Uyumsoft\StructType\PayableRoundingAmountType $payableRoundingAmount = null, \Novadan\Uyumsoft\StructType\PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }
    /**
     * Get LineExtensionAmount value
     * @return \Novadan\Uyumsoft\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Novadan\Uyumsoft\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setLineExtensionAmount(\Novadan\Uyumsoft\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return \Novadan\Uyumsoft\StructType\TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param \Novadan\Uyumsoft\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setTaxExclusiveAmount(\Novadan\Uyumsoft\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return \Novadan\Uyumsoft\StructType\TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param \Novadan\Uyumsoft\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setTaxInclusiveAmount(\Novadan\Uyumsoft\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return \Novadan\Uyumsoft\StructType\AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param \Novadan\Uyumsoft\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setAllowanceTotalAmount(\Novadan\Uyumsoft\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return \Novadan\Uyumsoft\StructType\ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param \Novadan\Uyumsoft\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setChargeTotalAmount(\Novadan\Uyumsoft\StructType\ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get PayableRoundingAmount value
     * @return \Novadan\Uyumsoft\StructType\PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }
    /**
     * Set PayableRoundingAmount value
     * @param \Novadan\Uyumsoft\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setPayableRoundingAmount(\Novadan\Uyumsoft\StructType\PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return \Novadan\Uyumsoft\StructType\PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param \Novadan\Uyumsoft\StructType\PayableAmountType $payableAmount
     * @return \Novadan\Uyumsoft\StructType\MonetaryTotalType
     */
    public function setPayableAmount(\Novadan\Uyumsoft\StructType\PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
}
