<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q133:Description
     * @var \Novadan\Uyumsoft\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q134:Name
     * @var \Novadan\Uyumsoft\StructType\NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q135:Keyword
     * @var \Novadan\Uyumsoft\StructType\KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q136:BrandName
     * @var \Novadan\Uyumsoft\StructType\BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q137:ModelName
     * @var \Novadan\Uyumsoft\StructType\ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemInstanceType[]
     */
    public $ItemInstance;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     * @param \Novadan\Uyumsoft\StructType\DescriptionType $description
     * @param \Novadan\Uyumsoft\StructType\NameType $name
     * @param \Novadan\Uyumsoft\StructType\KeywordType $keyword
     * @param \Novadan\Uyumsoft\StructType\BrandNameType $brandName
     * @param \Novadan\Uyumsoft\StructType\ModelNameType $modelName
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $buyersItemIdentification
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $sellersItemIdentification
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @param \Novadan\Uyumsoft\StructType\CountryType $originCountry
     * @param \Novadan\Uyumsoft\StructType\CommodityClassificationType[] $commodityClassification
     * @param \Novadan\Uyumsoft\StructType\ItemInstanceType[] $itemInstance
     */
    public function __construct(\Novadan\Uyumsoft\StructType\DescriptionType $description = null, \Novadan\Uyumsoft\StructType\NameType $name = null, \Novadan\Uyumsoft\StructType\KeywordType $keyword = null, \Novadan\Uyumsoft\StructType\BrandNameType $brandName = null, \Novadan\Uyumsoft\StructType\ModelNameType $modelName = null, \Novadan\Uyumsoft\StructType\ItemIdentificationType $buyersItemIdentification = null, \Novadan\Uyumsoft\StructType\ItemIdentificationType $sellersItemIdentification = null, \Novadan\Uyumsoft\StructType\ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), \Novadan\Uyumsoft\StructType\CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }
    /**
     * Get Description value
     * @return \Novadan\Uyumsoft\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Novadan\Uyumsoft\StructType\DescriptionType $description
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setDescription(\Novadan\Uyumsoft\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return \Novadan\Uyumsoft\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Novadan\Uyumsoft\StructType\NameType $name
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setName(\Novadan\Uyumsoft\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keyword value
     * @return \Novadan\Uyumsoft\StructType\KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \Novadan\Uyumsoft\StructType\KeywordType $keyword
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setKeyword(\Novadan\Uyumsoft\StructType\KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get BrandName value
     * @return \Novadan\Uyumsoft\StructType\BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param \Novadan\Uyumsoft\StructType\BrandNameType $brandName
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setBrandName(\Novadan\Uyumsoft\StructType\BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return \Novadan\Uyumsoft\StructType\ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param \Novadan\Uyumsoft\StructType\ModelNameType $modelName
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setModelName(\Novadan\Uyumsoft\StructType\ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * @return \Novadan\Uyumsoft\StructType\ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }
    /**
     * Set BuyersItemIdentification value
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $buyersItemIdentification
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setBuyersItemIdentification(\Novadan\Uyumsoft\StructType\ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * @return \Novadan\Uyumsoft\StructType\ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }
    /**
     * Set SellersItemIdentification value
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $sellersItemIdentification
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setSellersItemIdentification(\Novadan\Uyumsoft\StructType\ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return \Novadan\Uyumsoft\StructType\ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setManufacturersItemIdentification(\Novadan\Uyumsoft\StructType\ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
    /**
     * Get AdditionalItemIdentification value
     * @return \Novadan\Uyumsoft\StructType\ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeAdditionalItemIdentificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeAdditionalItemIdentificationItem instanceof \Novadan\Uyumsoft\StructType\ItemIdentificationType) {
                $invalidValues[] = is_object($itemTypeAdditionalItemIdentificationItem) ? get_class($itemTypeAdditionalItemIdentificationItem) : sprintf('%s(%s)', gettype($itemTypeAdditionalItemIdentificationItem), var_export($itemTypeAdditionalItemIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemIdentification property can only contain items of type \Novadan\Uyumsoft\StructType\ItemIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemIdentificationArrayErrorMessage = self::validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification($additionalItemIdentification))) {
            throw new \InvalidArgumentException($additionalItemIdentificationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }
    /**
     * Add item to AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemIdentificationType $item
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function addToAdditionalItemIdentification(\Novadan\Uyumsoft\StructType\ItemIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ItemIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemIdentification property can only contain items of type \Novadan\Uyumsoft\StructType\ItemIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return \Novadan\Uyumsoft\StructType\CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param \Novadan\Uyumsoft\StructType\CountryType $originCountry
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setOriginCountry(\Novadan\Uyumsoft\StructType\CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return \Novadan\Uyumsoft\StructType\CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodityClassification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodityClassification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeCommodityClassificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeCommodityClassificationItem instanceof \Novadan\Uyumsoft\StructType\CommodityClassificationType) {
                $invalidValues[] = is_object($itemTypeCommodityClassificationItem) ? get_class($itemTypeCommodityClassificationItem) : sprintf('%s(%s)', gettype($itemTypeCommodityClassificationItem), var_export($itemTypeCommodityClassificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommodityClassification property can only contain items of type \Novadan\Uyumsoft\StructType\CommodityClassificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\CommodityClassificationType[] $commodityClassification
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        // validation for constraint: array
        if ('' !== ($commodityClassificationArrayErrorMessage = self::validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification($commodityClassification))) {
            throw new \InvalidArgumentException($commodityClassificationArrayErrorMessage, __LINE__);
        }
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Add item to CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\CommodityClassificationType $item
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function addToCommodityClassification(\Novadan\Uyumsoft\StructType\CommodityClassificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\CommodityClassificationType) {
            throw new \InvalidArgumentException(sprintf('The CommodityClassification property can only contain items of type \Novadan\Uyumsoft\StructType\CommodityClassificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommodityClassification[] = $item;
        return $this;
    }
    /**
     * Get ItemInstance value
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }
    /**
     * This method is responsible for validating the values passed to the setItemInstance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemInstance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemInstanceForArrayConstraintsFromSetItemInstance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeItemInstanceItem) {
            // validation for constraint: itemType
            if (!$itemTypeItemInstanceItem instanceof \Novadan\Uyumsoft\StructType\ItemInstanceType) {
                $invalidValues[] = is_object($itemTypeItemInstanceItem) ? get_class($itemTypeItemInstanceItem) : sprintf('%s(%s)', gettype($itemTypeItemInstanceItem), var_export($itemTypeItemInstanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemInstance property can only contain items of type \Novadan\Uyumsoft\StructType\ItemInstanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemInstanceType[] $itemInstance
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function setItemInstance(array $itemInstance = array())
    {
        // validation for constraint: array
        if ('' !== ($itemInstanceArrayErrorMessage = self::validateItemInstanceForArrayConstraintsFromSetItemInstance($itemInstance))) {
            throw new \InvalidArgumentException($itemInstanceArrayErrorMessage, __LINE__);
        }
        $this->ItemInstance = $itemInstance;
        return $this;
    }
    /**
     * Add item to ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemInstanceType $item
     * @return \Novadan\Uyumsoft\StructType\ItemType
     */
    public function addToItemInstance(\Novadan\Uyumsoft\StructType\ItemInstanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ItemInstanceType) {
            throw new \InvalidArgumentException(sprintf('The ItemInstance property can only contain items of type \Novadan\Uyumsoft\StructType\ItemInstanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemInstance[] = $item;
        return $this;
    }
}
