<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q146:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q147:Name
     * @var \Novadan\Uyumsoft\StructType\NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q148:NameCode
     * @var \Novadan\Uyumsoft\StructType\NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q149:TestMethod
     * @var \Novadan\Uyumsoft\StructType\TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q150:Value
     * @var \Novadan\Uyumsoft\StructType\ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q151:ValueQuantity
     * @var \Novadan\Uyumsoft\StructType\ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q152:ValueQualifier
     * @var \Novadan\Uyumsoft\StructType\ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q153:ImportanceCode
     * @var \Novadan\Uyumsoft\StructType\ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q154:ListValue
     * @var \Novadan\Uyumsoft\StructType\ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemPropertyRangeType
     */
    public $ItemPropertyRange;
    /**
     * Constructor method for ItemPropertyType
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\NameType $name
     * @param \Novadan\Uyumsoft\StructType\NameCodeType $nameCode
     * @param \Novadan\Uyumsoft\StructType\TestMethodType $testMethod
     * @param \Novadan\Uyumsoft\StructType\ValueType $value
     * @param \Novadan\Uyumsoft\StructType\ValueQuantityType $valueQuantity
     * @param \Novadan\Uyumsoft\StructType\ValueQualifierType[] $valueQualifier
     * @param \Novadan\Uyumsoft\StructType\ImportanceCodeType $importanceCode
     * @param \Novadan\Uyumsoft\StructType\ListValueType[] $listValue
     * @param \Novadan\Uyumsoft\StructType\PeriodType $usabilityPeriod
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @param \Novadan\Uyumsoft\StructType\DimensionType $rangeDimension
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyRangeType $itemPropertyRange
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\NameType $name = null, \Novadan\Uyumsoft\StructType\NameCodeType $nameCode = null, \Novadan\Uyumsoft\StructType\TestMethodType $testMethod = null, \Novadan\Uyumsoft\StructType\ValueType $value = null, \Novadan\Uyumsoft\StructType\ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), \Novadan\Uyumsoft\StructType\ImportanceCodeType $importanceCode = null, array $listValue = array(), \Novadan\Uyumsoft\StructType\PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), \Novadan\Uyumsoft\StructType\DimensionType $rangeDimension = null, \Novadan\Uyumsoft\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \Novadan\Uyumsoft\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Novadan\Uyumsoft\StructType\NameType $name
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setName(\Novadan\Uyumsoft\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameCode value
     * @return \Novadan\Uyumsoft\StructType\NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }
    /**
     * Set NameCode value
     * @param \Novadan\Uyumsoft\StructType\NameCodeType $nameCode
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setNameCode(\Novadan\Uyumsoft\StructType\NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }
    /**
     * Get TestMethod value
     * @return \Novadan\Uyumsoft\StructType\TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }
    /**
     * Set TestMethod value
     * @param \Novadan\Uyumsoft\StructType\TestMethodType $testMethod
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setTestMethod(\Novadan\Uyumsoft\StructType\TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }
    /**
     * Get Value value
     * @return \Novadan\Uyumsoft\StructType\ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Novadan\Uyumsoft\StructType\ValueType $value
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setValue(\Novadan\Uyumsoft\StructType\ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueQuantity value
     * @return \Novadan\Uyumsoft\StructType\ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }
    /**
     * Set ValueQuantity value
     * @param \Novadan\Uyumsoft\StructType\ValueQuantityType $valueQuantity
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setValueQuantity(\Novadan\Uyumsoft\StructType\ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }
    /**
     * Get ValueQualifier value
     * @return \Novadan\Uyumsoft\StructType\ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setValueQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueQualifierForArrayConstraintsFromSetValueQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeValueQualifierItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeValueQualifierItem instanceof \Novadan\Uyumsoft\StructType\ValueQualifierType) {
                $invalidValues[] = is_object($itemPropertyTypeValueQualifierItem) ? get_class($itemPropertyTypeValueQualifierItem) : sprintf('%s(%s)', gettype($itemPropertyTypeValueQualifierItem), var_export($itemPropertyTypeValueQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueQualifier property can only contain items of type \Novadan\Uyumsoft\StructType\ValueQualifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ValueQualifierType[] $valueQualifier
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($valueQualifierArrayErrorMessage = self::validateValueQualifierForArrayConstraintsFromSetValueQualifier($valueQualifier))) {
            throw new \InvalidArgumentException($valueQualifierArrayErrorMessage, __LINE__);
        }
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }
    /**
     * Add item to ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ValueQualifierType $item
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function addToValueQualifier(\Novadan\Uyumsoft\StructType\ValueQualifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ValueQualifierType) {
            throw new \InvalidArgumentException(sprintf('The ValueQualifier property can only contain items of type \Novadan\Uyumsoft\StructType\ValueQualifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueQualifier[] = $item;
        return $this;
    }
    /**
     * Get ImportanceCode value
     * @return \Novadan\Uyumsoft\StructType\ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }
    /**
     * Set ImportanceCode value
     * @param \Novadan\Uyumsoft\StructType\ImportanceCodeType $importanceCode
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setImportanceCode(\Novadan\Uyumsoft\StructType\ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }
    /**
     * Get ListValue value
     * @return \Novadan\Uyumsoft\StructType\ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }
    /**
     * This method is responsible for validating the values passed to the setListValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListValueForArrayConstraintsFromSetListValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeListValueItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeListValueItem instanceof \Novadan\Uyumsoft\StructType\ListValueType) {
                $invalidValues[] = is_object($itemPropertyTypeListValueItem) ? get_class($itemPropertyTypeListValueItem) : sprintf('%s(%s)', gettype($itemPropertyTypeListValueItem), var_export($itemPropertyTypeListValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListValue property can only contain items of type \Novadan\Uyumsoft\StructType\ListValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListValue value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ListValueType[] $listValue
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setListValue(array $listValue = array())
    {
        // validation for constraint: array
        if ('' !== ($listValueArrayErrorMessage = self::validateListValueForArrayConstraintsFromSetListValue($listValue))) {
            throw new \InvalidArgumentException($listValueArrayErrorMessage, __LINE__);
        }
        $this->ListValue = $listValue;
        return $this;
    }
    /**
     * Add item to ListValue value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ListValueType $item
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function addToListValue(\Novadan\Uyumsoft\StructType\ListValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ListValueType) {
            throw new \InvalidArgumentException(sprintf('The ListValue property can only contain items of type \Novadan\Uyumsoft\StructType\ListValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListValue[] = $item;
        return $this;
    }
    /**
     * Get UsabilityPeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }
    /**
     * Set UsabilityPeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $usabilityPeriod
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setUsabilityPeriod(\Novadan\Uyumsoft\StructType\PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }
    /**
     * Get ItemPropertyGroup value
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setItemPropertyGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPropertyGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeItemPropertyGroupItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeItemPropertyGroupItem instanceof \Novadan\Uyumsoft\StructType\ItemPropertyGroupType) {
                $invalidValues[] = is_object($itemPropertyTypeItemPropertyGroupItem) ? get_class($itemPropertyTypeItemPropertyGroupItem) : sprintf('%s(%s)', gettype($itemPropertyTypeItemPropertyGroupItem), var_export($itemPropertyTypeItemPropertyGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemPropertyGroup property can only contain items of type \Novadan\Uyumsoft\StructType\ItemPropertyGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPropertyGroupArrayErrorMessage = self::validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup($itemPropertyGroup))) {
            throw new \InvalidArgumentException($itemPropertyGroupArrayErrorMessage, __LINE__);
        }
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }
    /**
     * Add item to ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyGroupType $item
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function addToItemPropertyGroup(\Novadan\Uyumsoft\StructType\ItemPropertyGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ItemPropertyGroupType) {
            throw new \InvalidArgumentException(sprintf('The ItemPropertyGroup property can only contain items of type \Novadan\Uyumsoft\StructType\ItemPropertyGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }
    /**
     * Get RangeDimension value
     * @return \Novadan\Uyumsoft\StructType\DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }
    /**
     * Set RangeDimension value
     * @param \Novadan\Uyumsoft\StructType\DimensionType $rangeDimension
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setRangeDimension(\Novadan\Uyumsoft\StructType\DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }
    /**
     * Get ItemPropertyRange value
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }
    /**
     * Set ItemPropertyRange value
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyRangeType $itemPropertyRange
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType
     */
    public function setItemPropertyRange(\Novadan\Uyumsoft\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
}
