<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q140:ProductTraceID
     * @var \Novadan\Uyumsoft\StructType\ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q141:ManufactureDate
     * @var \Novadan\Uyumsoft\StructType\ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q142:ManufactureTime
     * @var \Novadan\Uyumsoft\StructType\ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q143:BestBeforeDate
     * @var \Novadan\Uyumsoft\StructType\BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q144:RegistrationID
     * @var \Novadan\Uyumsoft\StructType\RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q145:SerialID
     * @var \Novadan\Uyumsoft\StructType\SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LotIdentificationType
     */
    public $LotIdentification;
    /**
     * Constructor method for ItemInstanceType
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     * @param \Novadan\Uyumsoft\StructType\ProductTraceIDType $productTraceID
     * @param \Novadan\Uyumsoft\StructType\ManufactureDateType $manufactureDate
     * @param \Novadan\Uyumsoft\StructType\ManufactureTimeType $manufactureTime
     * @param \Novadan\Uyumsoft\StructType\BestBeforeDateType $bestBeforeDate
     * @param \Novadan\Uyumsoft\StructType\RegistrationIDType $registrationID
     * @param \Novadan\Uyumsoft\StructType\SerialIDType $serialID
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyType[] $additionalItemProperty
     * @param \Novadan\Uyumsoft\StructType\LotIdentificationType $lotIdentification
     */
    public function __construct(\Novadan\Uyumsoft\StructType\ProductTraceIDType $productTraceID = null, \Novadan\Uyumsoft\StructType\ManufactureDateType $manufactureDate = null, \Novadan\Uyumsoft\StructType\ManufactureTimeType $manufactureTime = null, \Novadan\Uyumsoft\StructType\BestBeforeDateType $bestBeforeDate = null, \Novadan\Uyumsoft\StructType\RegistrationIDType $registrationID = null, \Novadan\Uyumsoft\StructType\SerialIDType $serialID = null, array $additionalItemProperty = array(), \Novadan\Uyumsoft\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }
    /**
     * Get ProductTraceID value
     * @return \Novadan\Uyumsoft\StructType\ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }
    /**
     * Set ProductTraceID value
     * @param \Novadan\Uyumsoft\StructType\ProductTraceIDType $productTraceID
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setProductTraceID(\Novadan\Uyumsoft\StructType\ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return \Novadan\Uyumsoft\StructType\ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param \Novadan\Uyumsoft\StructType\ManufactureDateType $manufactureDate
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setManufactureDate(\Novadan\Uyumsoft\StructType\ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get ManufactureTime value
     * @return \Novadan\Uyumsoft\StructType\ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }
    /**
     * Set ManufactureTime value
     * @param \Novadan\Uyumsoft\StructType\ManufactureTimeType $manufactureTime
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setManufactureTime(\Novadan\Uyumsoft\StructType\ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }
    /**
     * Get BestBeforeDate value
     * @return \Novadan\Uyumsoft\StructType\BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }
    /**
     * Set BestBeforeDate value
     * @param \Novadan\Uyumsoft\StructType\BestBeforeDateType $bestBeforeDate
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setBestBeforeDate(\Novadan\Uyumsoft\StructType\BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return \Novadan\Uyumsoft\StructType\RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param \Novadan\Uyumsoft\StructType\RegistrationIDType $registrationID
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setRegistrationID(\Novadan\Uyumsoft\StructType\RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get SerialID value
     * @return \Novadan\Uyumsoft\StructType\SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }
    /**
     * Set SerialID value
     * @param \Novadan\Uyumsoft\StructType\SerialIDType $serialID
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setSerialID(\Novadan\Uyumsoft\StructType\SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Novadan\Uyumsoft\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInstanceTypeAdditionalItemPropertyItem) {
            // validation for constraint: itemType
            if (!$itemInstanceTypeAdditionalItemPropertyItem instanceof \Novadan\Uyumsoft\StructType\ItemPropertyType) {
                $invalidValues[] = is_object($itemInstanceTypeAdditionalItemPropertyItem) ? get_class($itemInstanceTypeAdditionalItemPropertyItem) : sprintf('%s(%s)', gettype($itemInstanceTypeAdditionalItemPropertyItem), var_export($itemInstanceTypeAdditionalItemPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemProperty property can only contain items of type \Novadan\Uyumsoft\StructType\ItemPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemPropertyArrayErrorMessage = self::validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty($additionalItemProperty))) {
            throw new \InvalidArgumentException($additionalItemPropertyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\ItemPropertyType $item
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function addToAdditionalItemProperty(\Novadan\Uyumsoft\StructType\ItemPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\ItemPropertyType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemProperty property can only contain items of type \Novadan\Uyumsoft\StructType\ItemPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Get LotIdentification value
     * @return \Novadan\Uyumsoft\StructType\LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }
    /**
     * Set LotIdentification value
     * @param \Novadan\Uyumsoft\StructType\LotIdentificationType $lotIdentification
     * @return \Novadan\Uyumsoft\StructType\ItemInstanceType
     */
    public function setLotIdentification(\Novadan\Uyumsoft\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
}
