<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceIdentity StructType
 * @subpackage Structs
 */
class InvoiceIdentity extends AbstractStructBase
{
    /**
     * The InvoiceScenario
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $InvoiceScenario;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * Constructor method for InvoiceIdentity
     * @uses InvoiceIdentity::setInvoiceScenario()
     * @uses InvoiceIdentity::setId()
     * @uses InvoiceIdentity::setNumber()
     * @param string $invoiceScenario
     * @param string $id
     * @param string $number
     */
    public function __construct($invoiceScenario = null, $id = null, $number = null)
    {
        $this
            ->setInvoiceScenario($invoiceScenario)
            ->setId($id)
            ->setNumber($number);
    }
    /**
     * Get InvoiceScenario value
     * @return string
     */
    public function getInvoiceScenario()
    {
        return $this->InvoiceScenario;
    }
    /**
     * Set InvoiceScenario value
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::valueIsValid()
     * @uses \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceScenario
     * @return \Novadan\Uyumsoft\StructType\InvoiceIdentity
     */
    public function setInvoiceScenario($invoiceScenario = null)
    {
        // validation for constraint: enumeration
        if (!\Novadan\Uyumsoft\EnumType\InvoiceScenarioType::valueIsValid($invoiceScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Novadan\Uyumsoft\EnumType\InvoiceScenarioType', is_array($invoiceScenario) ? implode(', ', $invoiceScenario) : var_export($invoiceScenario, true), implode(', ', \Novadan\Uyumsoft\EnumType\InvoiceScenarioType::getValidValues())), __LINE__);
        }
        $this->InvoiceScenario = $invoiceScenario;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Novadan\Uyumsoft\StructType\InvoiceIdentity
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Novadan\Uyumsoft\StructType\InvoiceIdentity
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
}
