<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q11:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q12:IssueDate
     * @var \Novadan\Uyumsoft\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q13:DocumentTypeCode
     * @var \Novadan\Uyumsoft\StructType\DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q14:DocumentType
     * @var \Novadan\Uyumsoft\StructType\DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q15:DocumentDescription
     * @var \Novadan\Uyumsoft\StructType\DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $IssuerParty;
    /**
     * Constructor method for DocumentReferenceType
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\IssueDateType $issueDate
     * @param \Novadan\Uyumsoft\StructType\DocumentTypeCodeType $documentTypeCode
     * @param \Novadan\Uyumsoft\StructType\DocumentTypeType $documentType
     * @param \Novadan\Uyumsoft\StructType\DocumentDescriptionType[] $documentDescription
     * @param \Novadan\Uyumsoft\StructType\AttachmentType $attachment
     * @param \Novadan\Uyumsoft\StructType\PeriodType $validityPeriod
     * @param \Novadan\Uyumsoft\StructType\PartyType $issuerParty
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\IssueDateType $issueDate = null, \Novadan\Uyumsoft\StructType\DocumentTypeCodeType $documentTypeCode = null, \Novadan\Uyumsoft\StructType\DocumentTypeType $documentType = null, array $documentDescription = array(), \Novadan\Uyumsoft\StructType\AttachmentType $attachment = null, \Novadan\Uyumsoft\StructType\PeriodType $validityPeriod = null, \Novadan\Uyumsoft\StructType\PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Novadan\Uyumsoft\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Novadan\Uyumsoft\StructType\IssueDateType $issueDate
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setIssueDate(\Novadan\Uyumsoft\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return \Novadan\Uyumsoft\StructType\DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param \Novadan\Uyumsoft\StructType\DocumentTypeCodeType $documentTypeCode
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setDocumentTypeCode(\Novadan\Uyumsoft\StructType\DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \Novadan\Uyumsoft\StructType\DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \Novadan\Uyumsoft\StructType\DocumentTypeType $documentType
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setDocumentType(\Novadan\Uyumsoft\StructType\DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return \Novadan\Uyumsoft\StructType\DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentReferenceTypeDocumentDescriptionItem) {
            // validation for constraint: itemType
            if (!$documentReferenceTypeDocumentDescriptionItem instanceof \Novadan\Uyumsoft\StructType\DocumentDescriptionType) {
                $invalidValues[] = is_object($documentReferenceTypeDocumentDescriptionItem) ? get_class($documentReferenceTypeDocumentDescriptionItem) : sprintf('%s(%s)', gettype($documentReferenceTypeDocumentDescriptionItem), var_export($documentReferenceTypeDocumentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDescription property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentDescriptionType[] $documentDescription
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDescriptionArrayErrorMessage = self::validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription($documentDescription))) {
            throw new \InvalidArgumentException($documentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Add item to DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DocumentDescriptionType $item
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function addToDocumentDescription(\Novadan\Uyumsoft\StructType\DocumentDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DocumentDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The DocumentDescription property can only contain items of type \Novadan\Uyumsoft\StructType\DocumentDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDescription[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Novadan\Uyumsoft\StructType\AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Novadan\Uyumsoft\StructType\AttachmentType $attachment
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setAttachment(\Novadan\Uyumsoft\StructType\AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $validityPeriod
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setValidityPeriod(\Novadan\Uyumsoft\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IssuerParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }
    /**
     * Set IssuerParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $issuerParty
     * @return \Novadan\Uyumsoft\StructType\DocumentReferenceType
     */
    public function setIssuerParty(\Novadan\Uyumsoft\StructType\PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
}
