<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionType StructType
 * @subpackage Structs
 */
class DimensionType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q158:AttributeID
     * @var \Novadan\Uyumsoft\StructType\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q159:Measure
     * @var \Novadan\Uyumsoft\StructType\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: q160:Description
     * @var \Novadan\Uyumsoft\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The MinimumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q161:MinimumMeasure
     * @var \Novadan\Uyumsoft\StructType\MinimumMeasureType
     */
    public $MinimumMeasure;
    /**
     * The MaximumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q162:MaximumMeasure
     * @var \Novadan\Uyumsoft\StructType\MaximumMeasureType
     */
    public $MaximumMeasure;
    /**
     * Constructor method for DimensionType
     * @uses DimensionType::setAttributeID()
     * @uses DimensionType::setMeasure()
     * @uses DimensionType::setDescription()
     * @uses DimensionType::setMinimumMeasure()
     * @uses DimensionType::setMaximumMeasure()
     * @param \Novadan\Uyumsoft\StructType\AttributeIDType $attributeID
     * @param \Novadan\Uyumsoft\StructType\MeasureType $measure
     * @param \Novadan\Uyumsoft\StructType\DescriptionType[] $description
     * @param \Novadan\Uyumsoft\StructType\MinimumMeasureType $minimumMeasure
     * @param \Novadan\Uyumsoft\StructType\MaximumMeasureType $maximumMeasure
     */
    public function __construct(\Novadan\Uyumsoft\StructType\AttributeIDType $attributeID = null, \Novadan\Uyumsoft\StructType\MeasureType $measure = null, array $description = array(), \Novadan\Uyumsoft\StructType\MinimumMeasureType $minimumMeasure = null, \Novadan\Uyumsoft\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description)
            ->setMinimumMeasure($minimumMeasure)
            ->setMaximumMeasure($maximumMeasure);
    }
    /**
     * Get AttributeID value
     * @return \Novadan\Uyumsoft\StructType\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Novadan\Uyumsoft\StructType\AttributeIDType $attributeID
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function setAttributeID(\Novadan\Uyumsoft\StructType\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Novadan\Uyumsoft\StructType\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Novadan\Uyumsoft\StructType\MeasureType $measure
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function setMeasure(\Novadan\Uyumsoft\StructType\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Novadan\Uyumsoft\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dimensionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$dimensionTypeDescriptionItem instanceof \Novadan\Uyumsoft\StructType\DescriptionType) {
                $invalidValues[] = is_object($dimensionTypeDescriptionItem) ? get_class($dimensionTypeDescriptionItem) : sprintf('%s(%s)', gettype($dimensionTypeDescriptionItem), var_export($dimensionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Novadan\Uyumsoft\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DescriptionType[] $description
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DescriptionType $item
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function addToDescription(\Novadan\Uyumsoft\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \Novadan\Uyumsoft\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get MinimumMeasure value
     * @return \Novadan\Uyumsoft\StructType\MinimumMeasureType|null
     */
    public function getMinimumMeasure()
    {
        return $this->MinimumMeasure;
    }
    /**
     * Set MinimumMeasure value
     * @param \Novadan\Uyumsoft\StructType\MinimumMeasureType $minimumMeasure
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function setMinimumMeasure(\Novadan\Uyumsoft\StructType\MinimumMeasureType $minimumMeasure = null)
    {
        $this->MinimumMeasure = $minimumMeasure;
        return $this;
    }
    /**
     * Get MaximumMeasure value
     * @return \Novadan\Uyumsoft\StructType\MaximumMeasureType|null
     */
    public function getMaximumMeasure()
    {
        return $this->MaximumMeasure;
    }
    /**
     * Set MaximumMeasure value
     * @param \Novadan\Uyumsoft\StructType\MaximumMeasureType $maximumMeasure
     * @return \Novadan\Uyumsoft\StructType\DimensionType
     */
    public function setMaximumMeasure(\Novadan\Uyumsoft\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this->MaximumMeasure = $maximumMeasure;
        return $this;
    }
}
