<?php

namespace Novadan\Uyumsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q82:ID
     * @var \Novadan\Uyumsoft\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q83:Quantity
     * @var \Novadan\Uyumsoft\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q84:ActualDeliveryDate
     * @var \Novadan\Uyumsoft\StructType\ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q85:ActualDeliveryTime
     * @var \Novadan\Uyumsoft\StructType\ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q86:LatestDeliveryDate
     * @var \Novadan\Uyumsoft\StructType\LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q87:LatestDeliveryTime
     * @var \Novadan\Uyumsoft\StructType\LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: q88:TrackingID
     * @var \Novadan\Uyumsoft\StructType\TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Novadan\Uyumsoft\StructType\ShipmentType
     */
    public $Shipment;
    /**
     * Constructor method for DeliveryType
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @param \Novadan\Uyumsoft\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @param \Novadan\Uyumsoft\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @param \Novadan\Uyumsoft\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @param \Novadan\Uyumsoft\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @param \Novadan\Uyumsoft\StructType\TrackingIDType $trackingID
     * @param \Novadan\Uyumsoft\StructType\AddressType $deliveryAddress
     * @param \Novadan\Uyumsoft\StructType\LocationType $alternativeDeliveryLocation
     * @param \Novadan\Uyumsoft\StructType\PeriodType $estimatedDeliveryPeriod
     * @param \Novadan\Uyumsoft\StructType\PartyType $carrierParty
     * @param \Novadan\Uyumsoft\StructType\PartyType $deliveryParty
     * @param \Novadan\Uyumsoft\StructType\DespatchType $despatch
     * @param \Novadan\Uyumsoft\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \Novadan\Uyumsoft\StructType\ShipmentType $shipment
     */
    public function __construct(\Novadan\Uyumsoft\StructType\IDType $iD = null, \Novadan\Uyumsoft\StructType\QuantityType $quantity = null, \Novadan\Uyumsoft\StructType\ActualDeliveryDateType $actualDeliveryDate = null, \Novadan\Uyumsoft\StructType\ActualDeliveryTimeType $actualDeliveryTime = null, \Novadan\Uyumsoft\StructType\LatestDeliveryDateType $latestDeliveryDate = null, \Novadan\Uyumsoft\StructType\LatestDeliveryTimeType $latestDeliveryTime = null, \Novadan\Uyumsoft\StructType\TrackingIDType $trackingID = null, \Novadan\Uyumsoft\StructType\AddressType $deliveryAddress = null, \Novadan\Uyumsoft\StructType\LocationType $alternativeDeliveryLocation = null, \Novadan\Uyumsoft\StructType\PeriodType $estimatedDeliveryPeriod = null, \Novadan\Uyumsoft\StructType\PartyType $carrierParty = null, \Novadan\Uyumsoft\StructType\PartyType $deliveryParty = null, \Novadan\Uyumsoft\StructType\DespatchType $despatch = null, array $deliveryTerms = array(), \Novadan\Uyumsoft\StructType\ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }
    /**
     * Get ID value
     * @return \Novadan\Uyumsoft\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Novadan\Uyumsoft\StructType\IDType $iD
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setID(\Novadan\Uyumsoft\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Novadan\Uyumsoft\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Novadan\Uyumsoft\StructType\QuantityType $quantity
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setQuantity(\Novadan\Uyumsoft\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualDeliveryDate value
     * @return \Novadan\Uyumsoft\StructType\ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }
    /**
     * Set ActualDeliveryDate value
     * @param \Novadan\Uyumsoft\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setActualDeliveryDate(\Novadan\Uyumsoft\StructType\ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get ActualDeliveryTime value
     * @return \Novadan\Uyumsoft\StructType\ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }
    /**
     * Set ActualDeliveryTime value
     * @param \Novadan\Uyumsoft\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setActualDeliveryTime(\Novadan\Uyumsoft\StructType\ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }
    /**
     * Get LatestDeliveryDate value
     * @return \Novadan\Uyumsoft\StructType\LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }
    /**
     * Set LatestDeliveryDate value
     * @param \Novadan\Uyumsoft\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setLatestDeliveryDate(\Novadan\Uyumsoft\StructType\LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get LatestDeliveryTime value
     * @return \Novadan\Uyumsoft\StructType\LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }
    /**
     * Set LatestDeliveryTime value
     * @param \Novadan\Uyumsoft\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setLatestDeliveryTime(\Novadan\Uyumsoft\StructType\LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \Novadan\Uyumsoft\StructType\TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \Novadan\Uyumsoft\StructType\TrackingIDType $trackingID
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setTrackingID(\Novadan\Uyumsoft\StructType\TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \Novadan\Uyumsoft\StructType\AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \Novadan\Uyumsoft\StructType\AddressType $deliveryAddress
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setDeliveryAddress(\Novadan\Uyumsoft\StructType\AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * @return \Novadan\Uyumsoft\StructType\LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * @param \Novadan\Uyumsoft\StructType\LocationType $alternativeDeliveryLocation
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setAlternativeDeliveryLocation(\Novadan\Uyumsoft\StructType\LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * @return \Novadan\Uyumsoft\StructType\PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * @param \Novadan\Uyumsoft\StructType\PeriodType $estimatedDeliveryPeriod
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setEstimatedDeliveryPeriod(\Novadan\Uyumsoft\StructType\PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }
    /**
     * Get CarrierParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }
    /**
     * Set CarrierParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $carrierParty
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setCarrierParty(\Novadan\Uyumsoft\StructType\PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }
    /**
     * Get DeliveryParty value
     * @return \Novadan\Uyumsoft\StructType\PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }
    /**
     * Set DeliveryParty value
     * @param \Novadan\Uyumsoft\StructType\PartyType $deliveryParty
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setDeliveryParty(\Novadan\Uyumsoft\StructType\PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }
    /**
     * Get Despatch value
     * @return \Novadan\Uyumsoft\StructType\DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }
    /**
     * Set Despatch value
     * @param \Novadan\Uyumsoft\StructType\DespatchType $despatch
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setDespatch(\Novadan\Uyumsoft\StructType\DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \Novadan\Uyumsoft\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$deliveryTypeDeliveryTermsItem instanceof \Novadan\Uyumsoft\StructType\DeliveryTermsType) {
                $invalidValues[] = is_object($deliveryTypeDeliveryTermsItem) ? get_class($deliveryTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($deliveryTypeDeliveryTermsItem), var_export($deliveryTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \Novadan\Uyumsoft\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new \InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\DeliveryTermsType $item
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function addToDeliveryTerms(\Novadan\Uyumsoft\StructType\DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\DeliveryTermsType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \Novadan\Uyumsoft\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Novadan\Uyumsoft\StructType\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Novadan\Uyumsoft\StructType\ShipmentType $shipment
     * @return \Novadan\Uyumsoft\StructType\DeliveryType
     */
    public function setShipment(\Novadan\Uyumsoft\StructType\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
}
