<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetXsltView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SetXsltView $parameters
     * @return \Novadan\Uyumsoft\StructType\SetXsltViewResponse|bool
     */
    public function SetXsltView(\Novadan\Uyumsoft\StructType\SetXsltView $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetXsltView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetInvoicesTaken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SetInvoicesTaken $parameters
     * @return \Novadan\Uyumsoft\StructType\SetInvoicesTakenResponse|bool
     */
    public function SetInvoicesTaken(\Novadan\Uyumsoft\StructType\SetInvoicesTaken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetInvoicesTaken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\SetInvoicesTakenResponse|\Novadan\Uyumsoft\StructType\SetXsltViewResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
