<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendDocumentResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SendDocumentResponse $parameters
     * @return \Novadan\Uyumsoft\StructType\SendDocumentResponseResponse|bool
     */
    public function SendDocumentResponse(\Novadan\Uyumsoft\StructType\SendDocumentResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDocumentResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SendInvoice $parameters
     * @return \Novadan\Uyumsoft\StructType\SendInvoiceResponse|bool
     */
    public function SendInvoice(\Novadan\Uyumsoft\StructType\SendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDraft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\SendDraft $parameters
     * @return \Novadan\Uyumsoft\StructType\SendDraftResponse|bool
     */
    public function SendDraft(\Novadan\Uyumsoft\StructType\SendDraft $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDraft($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\SendDocumentResponseResponse|\Novadan\Uyumsoft\StructType\SendDraftResponse|\Novadan\Uyumsoft\StructType\SendInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
