<?php

namespace Novadan\Uyumsoft\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retry ServiceType
 * @subpackage Services
 */
class Retry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrySendInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Novadan\Uyumsoft\StructType\RetrySendInvoices $parameters
     * @return \Novadan\Uyumsoft\StructType\RetrySendInvoicesResponse|bool
     */
    public function RetrySendInvoices(\Novadan\Uyumsoft\StructType\RetrySendInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrySendInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Novadan\Uyumsoft\StructType\RetrySendInvoicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
