<?php

namespace Novadan\Uyumsoft\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineResponseInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfLineResponseInfo extends AbstractStructArrayBase
{
    /**
     * The LineResponseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Novadan\Uyumsoft\StructType\LineResponseInfo[]
     */
    public $LineResponseInfo;
    /**
     * Constructor method for ArrayOfLineResponseInfo
     * @uses ArrayOfLineResponseInfo::setLineResponseInfo()
     * @param \Novadan\Uyumsoft\StructType\LineResponseInfo[] $lineResponseInfo
     */
    public function __construct(array $lineResponseInfo = array())
    {
        $this
            ->setLineResponseInfo($lineResponseInfo);
    }
    /**
     * Get LineResponseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo[]|null
     */
    public function getLineResponseInfo()
    {
        return isset($this->LineResponseInfo) ? $this->LineResponseInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineResponseInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineResponseInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineResponseInfoForArrayConstraintsFromSetLineResponseInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLineResponseInfoLineResponseInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineResponseInfoLineResponseInfoItem instanceof \Novadan\Uyumsoft\StructType\LineResponseInfo) {
                $invalidValues[] = is_object($arrayOfLineResponseInfoLineResponseInfoItem) ? get_class($arrayOfLineResponseInfoLineResponseInfoItem) : sprintf('%s(%s)', gettype($arrayOfLineResponseInfoLineResponseInfoItem), var_export($arrayOfLineResponseInfoLineResponseInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineResponseInfo property can only contain items of type \Novadan\Uyumsoft\StructType\LineResponseInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineResponseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\LineResponseInfo[] $lineResponseInfo
     * @return \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo
     */
    public function setLineResponseInfo(array $lineResponseInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($lineResponseInfoArrayErrorMessage = self::validateLineResponseInfoForArrayConstraintsFromSetLineResponseInfo($lineResponseInfo))) {
            throw new \InvalidArgumentException($lineResponseInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($lineResponseInfo) || (is_array($lineResponseInfo) && empty($lineResponseInfo))) {
            unset($this->LineResponseInfo);
        } else {
            $this->LineResponseInfo = $lineResponseInfo;
        }
        return $this;
    }
    /**
     * Add item to LineResponseInfo value
     * @throws \InvalidArgumentException
     * @param \Novadan\Uyumsoft\StructType\LineResponseInfo $item
     * @return \Novadan\Uyumsoft\ArrayType\ArrayOfLineResponseInfo
     */
    public function addToLineResponseInfo(\Novadan\Uyumsoft\StructType\LineResponseInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Novadan\Uyumsoft\StructType\LineResponseInfo) {
            throw new \InvalidArgumentException(sprintf('The LineResponseInfo property can only contain items of type \Novadan\Uyumsoft\StructType\LineResponseInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineResponseInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Novadan\Uyumsoft\StructType\LineResponseInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineResponseInfo
     */
    public function getAttributeName()
    {
        return 'LineResponseInfo';
    }
}
