<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentValidationResponse StructType
 * @subpackage Structs
 */
class ShipmentValidationResponse extends AbstractStructBase
{
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Shipment[]
     */
    public $Shipment;
    /**
     * Constructor method for ShipmentValidationResponse
     * @uses ShipmentValidationResponse::setShipment()
     * @param \StructType\Shipment[] $shipment
     */
    public function __construct(array $shipment = array())
    {
        $this
            ->setShipment($shipment);
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment[]
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * This method is responsible for validating the values passed to the setShipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentForArrayConstraintsFromSetShipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentValidationResponseShipmentItem) {
            // validation for constraint: itemType
            if (!$shipmentValidationResponseShipmentItem instanceof \StructType\Shipment) {
                $invalidValues[] = is_object($shipmentValidationResponseShipmentItem) ? get_class($shipmentValidationResponseShipmentItem) : sprintf('%s(%s)', gettype($shipmentValidationResponseShipmentItem), var_export($shipmentValidationResponseShipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment[] $shipment
     * @return \StructType\ShipmentValidationResponse
     */
    public function setShipment(array $shipment = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentArrayErrorMessage = self::validateShipmentForArrayConstraintsFromSetShipment($shipment))) {
            throw new \InvalidArgumentException($shipmentArrayErrorMessage, __LINE__);
        }
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Add item to Shipment value
     * @throws \InvalidArgumentException
     * @param \StructType\Shipment $item
     * @return \StructType\ShipmentValidationResponse
     */
    public function addToShipment(\StructType\Shipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shipment) {
            throw new \InvalidArgumentException(sprintf('The Shipment property can only contain items of type \StructType\Shipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shipment[] = $item;
        return $this;
    }
}
