<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDetails StructType
 * @subpackage Structs
 */
class ShipmentDetails extends AbstractStructBase
{
    /**
     * The Consignor
     * Meta information extracted from the WSDL
     * - documentation: Consignor | Versender
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressConsignor
     */
    public $Consignor;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Product / Service | Produkt / Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ShipmentService
     */
    public $Service;
    /**
     * Constructor method for ShipmentDetails
     * @uses ShipmentDetails::setConsignor()
     * @uses ShipmentDetails::setService()
     * @param \StructType\AddressConsignor $consignor
     * @param \StructType\ShipmentService $service
     */
    public function __construct(\StructType\AddressConsignor $consignor = null, \StructType\ShipmentService $service = null)
    {
        $this
            ->setConsignor($consignor)
            ->setService($service);
    }
    /**
     * Get Consignor value
     * @return \StructType\AddressConsignor
     */
    public function getConsignor()
    {
        return $this->Consignor;
    }
    /**
     * Set Consignor value
     * @param \StructType\AddressConsignor $consignor
     * @return \StructType\ShipmentDetails
     */
    public function setConsignor(\StructType\AddressConsignor $consignor = null)
    {
        $this->Consignor = $consignor;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ShipmentService
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\ShipmentService $service
     * @return \StructType\ShipmentDetails
     */
    public function setService(\StructType\ShipmentService $service = null)
    {
        $this->Service = $service;
        return $this;
    }
}
