<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The Field
     * Meta information extracted from the WSDL
     * - documentation: AX4 field name | AX4 Feldname
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field;
    /**
     * The Errormessage
     * Meta information extracted from the WSDL
     * - documentation: Errormessage | Fehlerbeschreibung
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Errormessage;
    /**
     * The Stacktrace
     * Meta information extracted from the WSDL
     * - documentation: Stacktrace
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Stacktrace;
    /**
     * Constructor method for Error
     * @uses Error::setField()
     * @uses Error::setErrormessage()
     * @uses Error::setStacktrace()
     * @param string $field
     * @param string $errormessage
     * @param string $stacktrace
     */
    public function __construct($field = null, $errormessage = null, $stacktrace = null)
    {
        $this
            ->setField($field)
            ->setErrormessage($errormessage)
            ->setStacktrace($stacktrace);
    }
    /**
     * Get Field value
     * @return string|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @param string $field
     * @return \StructType\Error
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($field) && mb_strlen($field) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($field)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($field) && mb_strlen($field) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($field)), __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Errormessage value
     * @return string|null
     */
    public function getErrormessage()
    {
        return $this->Errormessage;
    }
    /**
     * Set Errormessage value
     * @param string $errormessage
     * @return \StructType\Error
     */
    public function setErrormessage($errormessage = null)
    {
        // validation for constraint: string
        if (!is_null($errormessage) && !is_string($errormessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errormessage, true), gettype($errormessage)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($errormessage) && mb_strlen($errormessage) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($errormessage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errormessage) && mb_strlen($errormessage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errormessage)), __LINE__);
        }
        $this->Errormessage = $errormessage;
        return $this;
    }
    /**
     * Get Stacktrace value
     * @return string|null
     */
    public function getStacktrace()
    {
        return $this->Stacktrace;
    }
    /**
     * Set Stacktrace value
     * @param string $stacktrace
     * @return \StructType\Error
     */
    public function setStacktrace($stacktrace = null)
    {
        // validation for constraint: string
        if (!is_null($stacktrace) && !is_string($stacktrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stacktrace, true), gettype($stacktrace)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($stacktrace) && mb_strlen($stacktrace) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($stacktrace)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($stacktrace) && mb_strlen($stacktrace) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($stacktrace)), __LINE__);
        }
        $this->Stacktrace = $stacktrace;
        return $this;
    }
}
