<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DangerousgoodsDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Dangerousgoods information | Gefahrgutinformationen
 * @subpackage Structs
 */
class DangerousgoodsDetails extends AbstractStructBase
{
    /**
     * The PackageAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount of packages | Packstückanzahl
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageAmount;
    /**
     * The TechnicalName
     * Meta information extracted from the WSDL
     * - documentation: Dangerous goods, technical name | technischer Name
     * - base: xsd:string
     * - maxLength: 182
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $TechnicalName;
    /**
     * The EnvironmentallyHazardous
     * Meta information extracted from the WSDL
     * - documentation: Environmentally hazardous | Umweltgefährdend
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnvironmentallyHazardous;
    /**
     * The FreeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Free quantity | freigestellte Menge
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FreeQuantity;
    /**
     * The LimitedQuantity
     * Meta information extracted from the WSDL
     * - documentation: Limited quantity | begrenzte Menge
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LimitedQuantity;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - documentation: Packing instruction | Verpackungscode
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageType;
    /**
     * The HazardIdentification
     * Meta information extracted from the WSDL
     * - documentation: Hazard identification | Klasse
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $HazardIdentification;
    /**
     * The ClassCode
     * Meta information extracted from the WSDL
     * - documentation: Class code | Klassifizierungscode
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClassCode;
    /**
     * The UNNUmber
     * Meta information extracted from the WSDL
     * - documentation: UNDG number | UN Nummer
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $UNNUmber;
    /**
     * The DGID
     * Meta information extracted from the WSDL
     * - documentation: DGID
     * - base: xsd:string
     * - maxLength: 38
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DGID;
    /**
     * The PackingGroup
     * Meta information extracted from the WSDL
     * - documentation: Packing group | Verpackungsgruppe
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackingGroup;
    /**
     * The NOSText
     * Meta information extracted from the WSDL
     * - documentation: N.O.S. Text | N.A.G. Text
     * - base: xsd:string
     * - maxLength: 300
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NOSText;
    /**
     * The Mass
     * Meta information extracted from the WSDL
     * - documentation: Mass | Masse
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 999.99
     * - maxOccurs: 1
     * - minInclusive: 0.0
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,2}.[0-9]{2}
     * - totalDigits: 5
     * @var float
     */
    public $Mass;
    /**
     * The MassUnit
     * Meta information extracted from the WSDL
     * - documentation: Mass unit | Masseeinheit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MassUnit;
    /**
     * The Tunnelrestrictioncode
     * Meta information extracted from the WSDL
     * - documentation: Tunnelrestrictioncode | Tunnelbeschränkungscode
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tunnelrestrictioncode;
    /**
     * The TransportMode
     * Meta information extracted from the WSDL
     * - documentation: Transport Mode
     * - base: xsd:string
     * - maxLength: 24
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransportMode;
    /**
     * Constructor method for DangerousgoodsDetails
     * @uses DangerousgoodsDetails::setPackageAmount()
     * @uses DangerousgoodsDetails::setTechnicalName()
     * @uses DangerousgoodsDetails::setEnvironmentallyHazardous()
     * @uses DangerousgoodsDetails::setFreeQuantity()
     * @uses DangerousgoodsDetails::setLimitedQuantity()
     * @uses DangerousgoodsDetails::setPackageType()
     * @uses DangerousgoodsDetails::setHazardIdentification()
     * @uses DangerousgoodsDetails::setClassCode()
     * @uses DangerousgoodsDetails::setUNNUmber()
     * @uses DangerousgoodsDetails::setDGID()
     * @uses DangerousgoodsDetails::setPackingGroup()
     * @uses DangerousgoodsDetails::setNOSText()
     * @uses DangerousgoodsDetails::setMass()
     * @uses DangerousgoodsDetails::setMassUnit()
     * @uses DangerousgoodsDetails::setTunnelrestrictioncode()
     * @uses DangerousgoodsDetails::setTransportMode()
     * @param string $packageAmount
     * @param string $technicalName
     * @param string $environmentallyHazardous
     * @param string $freeQuantity
     * @param string $limitedQuantity
     * @param string $packageType
     * @param string $hazardIdentification
     * @param string $classCode
     * @param string $uNNUmber
     * @param string $dGID
     * @param string $packingGroup
     * @param string $nOSText
     * @param float $mass
     * @param string $massUnit
     * @param string $tunnelrestrictioncode
     * @param string $transportMode
     */
    public function __construct($packageAmount = null, $technicalName = null, $environmentallyHazardous = null, $freeQuantity = null, $limitedQuantity = null, $packageType = null, $hazardIdentification = null, $classCode = null, $uNNUmber = null, $dGID = null, $packingGroup = null, $nOSText = null, $mass = null, $massUnit = null, $tunnelrestrictioncode = null, $transportMode = null)
    {
        $this
            ->setPackageAmount($packageAmount)
            ->setTechnicalName($technicalName)
            ->setEnvironmentallyHazardous($environmentallyHazardous)
            ->setFreeQuantity($freeQuantity)
            ->setLimitedQuantity($limitedQuantity)
            ->setPackageType($packageType)
            ->setHazardIdentification($hazardIdentification)
            ->setClassCode($classCode)
            ->setUNNUmber($uNNUmber)
            ->setDGID($dGID)
            ->setPackingGroup($packingGroup)
            ->setNOSText($nOSText)
            ->setMass($mass)
            ->setMassUnit($massUnit)
            ->setTunnelrestrictioncode($tunnelrestrictioncode)
            ->setTransportMode($transportMode);
    }
    /**
     * Get PackageAmount value
     * @return string
     */
    public function getPackageAmount()
    {
        return $this->PackageAmount;
    }
    /**
     * Set PackageAmount value
     * @param string $packageAmount
     * @return \StructType\DangerousgoodsDetails
     */
    public function setPackageAmount($packageAmount = null)
    {
        // validation for constraint: string
        if (!is_null($packageAmount) && !is_string($packageAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageAmount, true), gettype($packageAmount)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageAmount)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageAmount)), __LINE__);
        }
        $this->PackageAmount = $packageAmount;
        return $this;
    }
    /**
     * Get TechnicalName value
     * @return string
     */
    public function getTechnicalName()
    {
        return $this->TechnicalName;
    }
    /**
     * Set TechnicalName value
     * @param string $technicalName
     * @return \StructType\DangerousgoodsDetails
     */
    public function setTechnicalName($technicalName = null)
    {
        // validation for constraint: string
        if (!is_null($technicalName) && !is_string($technicalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technicalName, true), gettype($technicalName)), __LINE__);
        }
        // validation for constraint: maxLength(182)
        if (!is_null($technicalName) && mb_strlen($technicalName) > 182) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 182', mb_strlen($technicalName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($technicalName) && mb_strlen($technicalName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($technicalName)), __LINE__);
        }
        $this->TechnicalName = $technicalName;
        return $this;
    }
    /**
     * Get EnvironmentallyHazardous value
     * @return string
     */
    public function getEnvironmentallyHazardous()
    {
        return $this->EnvironmentallyHazardous;
    }
    /**
     * Set EnvironmentallyHazardous value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentallyHazardous
     * @return \StructType\DangerousgoodsDetails
     */
    public function setEnvironmentallyHazardous($environmentallyHazardous = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($environmentallyHazardous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($environmentallyHazardous) ? implode(', ', $environmentallyHazardous) : var_export($environmentallyHazardous, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->EnvironmentallyHazardous = $environmentallyHazardous;
        return $this;
    }
    /**
     * Get FreeQuantity value
     * @return string
     */
    public function getFreeQuantity()
    {
        return $this->FreeQuantity;
    }
    /**
     * Set FreeQuantity value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $freeQuantity
     * @return \StructType\DangerousgoodsDetails
     */
    public function setFreeQuantity($freeQuantity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($freeQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($freeQuantity) ? implode(', ', $freeQuantity) : var_export($freeQuantity, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->FreeQuantity = $freeQuantity;
        return $this;
    }
    /**
     * Get LimitedQuantity value
     * @return string
     */
    public function getLimitedQuantity()
    {
        return $this->LimitedQuantity;
    }
    /**
     * Set LimitedQuantity value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitedQuantity
     * @return \StructType\DangerousgoodsDetails
     */
    public function setLimitedQuantity($limitedQuantity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($limitedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($limitedQuantity) ? implode(', ', $limitedQuantity) : var_export($limitedQuantity, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->LimitedQuantity = $limitedQuantity;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @param string $packageType
     * @return \StructType\DangerousgoodsDetails
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($packageType) && mb_strlen($packageType) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($packageType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageType) && mb_strlen($packageType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageType)), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get HazardIdentification value
     * @return string|null
     */
    public function getHazardIdentification()
    {
        return $this->HazardIdentification;
    }
    /**
     * Set HazardIdentification value
     * @param string $hazardIdentification
     * @return \StructType\DangerousgoodsDetails
     */
    public function setHazardIdentification($hazardIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($hazardIdentification) && !is_string($hazardIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazardIdentification, true), gettype($hazardIdentification)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($hazardIdentification) && mb_strlen($hazardIdentification) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($hazardIdentification)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hazardIdentification) && mb_strlen($hazardIdentification) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hazardIdentification)), __LINE__);
        }
        $this->HazardIdentification = $hazardIdentification;
        return $this;
    }
    /**
     * Get ClassCode value
     * @return string|null
     */
    public function getClassCode()
    {
        return $this->ClassCode;
    }
    /**
     * Set ClassCode value
     * @param string $classCode
     * @return \StructType\DangerousgoodsDetails
     */
    public function setClassCode($classCode = null)
    {
        // validation for constraint: string
        if (!is_null($classCode) && !is_string($classCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classCode, true), gettype($classCode)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($classCode) && mb_strlen($classCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($classCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($classCode) && mb_strlen($classCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($classCode)), __LINE__);
        }
        $this->ClassCode = $classCode;
        return $this;
    }
    /**
     * Get UNNUmber value
     * @return string|null
     */
    public function getUNNUmber()
    {
        return $this->UNNUmber;
    }
    /**
     * Set UNNUmber value
     * @param string $uNNUmber
     * @return \StructType\DangerousgoodsDetails
     */
    public function setUNNUmber($uNNUmber = null)
    {
        // validation for constraint: string
        if (!is_null($uNNUmber) && !is_string($uNNUmber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uNNUmber, true), gettype($uNNUmber)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($uNNUmber) && mb_strlen($uNNUmber) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($uNNUmber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uNNUmber) && mb_strlen($uNNUmber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uNNUmber)), __LINE__);
        }
        $this->UNNUmber = $uNNUmber;
        return $this;
    }
    /**
     * Get DGID value
     * @return string|null
     */
    public function getDGID()
    {
        return $this->DGID;
    }
    /**
     * Set DGID value
     * @param string $dGID
     * @return \StructType\DangerousgoodsDetails
     */
    public function setDGID($dGID = null)
    {
        // validation for constraint: string
        if (!is_null($dGID) && !is_string($dGID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dGID, true), gettype($dGID)), __LINE__);
        }
        // validation for constraint: maxLength(38)
        if (!is_null($dGID) && mb_strlen($dGID) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 38', mb_strlen($dGID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dGID) && mb_strlen($dGID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dGID)), __LINE__);
        }
        $this->DGID = $dGID;
        return $this;
    }
    /**
     * Get PackingGroup value
     * @return string|null
     */
    public function getPackingGroup()
    {
        return $this->PackingGroup;
    }
    /**
     * Set PackingGroup value
     * @uses \EnumType\CodelistPackinggroup::valueIsValid()
     * @uses \EnumType\CodelistPackinggroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packingGroup
     * @return \StructType\DangerousgoodsDetails
     */
    public function setPackingGroup($packingGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistPackinggroup::valueIsValid($packingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistPackinggroup', is_array($packingGroup) ? implode(', ', $packingGroup) : var_export($packingGroup, true), implode(', ', \EnumType\CodelistPackinggroup::getValidValues())), __LINE__);
        }
        $this->PackingGroup = $packingGroup;
        return $this;
    }
    /**
     * Get NOSText value
     * @return string|null
     */
    public function getNOSText()
    {
        return $this->NOSText;
    }
    /**
     * Set NOSText value
     * @param string $nOSText
     * @return \StructType\DangerousgoodsDetails
     */
    public function setNOSText($nOSText = null)
    {
        // validation for constraint: string
        if (!is_null($nOSText) && !is_string($nOSText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nOSText, true), gettype($nOSText)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nOSText) && mb_strlen($nOSText) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nOSText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nOSText) && mb_strlen($nOSText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nOSText)), __LINE__);
        }
        $this->NOSText = $nOSText;
        return $this;
    }
    /**
     * Get Mass value
     * @return float|null
     */
    public function getMass()
    {
        return $this->Mass;
    }
    /**
     * Set Mass value
     * @param float $mass
     * @return \StructType\DangerousgoodsDetails
     */
    public function setMass($mass = null)
    {
        // validation for constraint: float
        if (!is_null($mass) && !(is_float($mass) || is_numeric($mass))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mass, true), gettype($mass)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($mass) && mb_strlen(mb_substr($mass, false !== mb_strpos($mass, '.') ? mb_strpos($mass, '.') + 1 : mb_strlen($mass))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($mass, true), mb_strlen(mb_substr($mass, mb_strpos($mass, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(999.99)
        if (!is_null($mass) && $mass > 999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999.99', var_export($mass, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($mass) && $mass < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($mass, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,2}.[0-9]{2})
        if (!is_null($mass) && !preg_match('/[1-9]{1}[0-9]{0,2}.[0-9]{2}/', $mass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,2}.[0-9]{2}', var_export($mass, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($mass) && mb_strlen(preg_replace('/(\D)/', '', $mass)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($mass, true), mb_strlen(preg_replace('/(\D)/', '', $mass))), __LINE__);
        }
        $this->Mass = $mass;
        return $this;
    }
    /**
     * Get MassUnit value
     * @return string|null
     */
    public function getMassUnit()
    {
        return $this->MassUnit;
    }
    /**
     * Set MassUnit value
     * @uses \EnumType\CodelistMassunit::valueIsValid()
     * @uses \EnumType\CodelistMassunit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $massUnit
     * @return \StructType\DangerousgoodsDetails
     */
    public function setMassUnit($massUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistMassunit::valueIsValid($massUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistMassunit', is_array($massUnit) ? implode(', ', $massUnit) : var_export($massUnit, true), implode(', ', \EnumType\CodelistMassunit::getValidValues())), __LINE__);
        }
        $this->MassUnit = $massUnit;
        return $this;
    }
    /**
     * Get Tunnelrestrictioncode value
     * @return string|null
     */
    public function getTunnelrestrictioncode()
    {
        return $this->Tunnelrestrictioncode;
    }
    /**
     * Set Tunnelrestrictioncode value
     * @param string $tunnelrestrictioncode
     * @return \StructType\DangerousgoodsDetails
     */
    public function setTunnelrestrictioncode($tunnelrestrictioncode = null)
    {
        // validation for constraint: string
        if (!is_null($tunnelrestrictioncode) && !is_string($tunnelrestrictioncode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tunnelrestrictioncode, true), gettype($tunnelrestrictioncode)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($tunnelrestrictioncode) && mb_strlen($tunnelrestrictioncode) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($tunnelrestrictioncode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tunnelrestrictioncode) && mb_strlen($tunnelrestrictioncode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tunnelrestrictioncode)), __LINE__);
        }
        $this->Tunnelrestrictioncode = $tunnelrestrictioncode;
        return $this;
    }
    /**
     * Get TransportMode value
     * @return string|null
     */
    public function getTransportMode()
    {
        return $this->TransportMode;
    }
    /**
     * Set TransportMode value
     * @param string $transportMode
     * @return \StructType\DangerousgoodsDetails
     */
    public function setTransportMode($transportMode = null)
    {
        // validation for constraint: string
        if (!is_null($transportMode) && !is_string($transportMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportMode, true), gettype($transportMode)), __LINE__);
        }
        // validation for constraint: maxLength(24)
        if (!is_null($transportMode) && mb_strlen($transportMode) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 24', mb_strlen($transportMode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transportMode) && mb_strlen($transportMode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transportMode)), __LINE__);
        }
        $this->TransportMode = $transportMode;
        return $this;
    }
}
