<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Avis StructType
 * Meta information extracted from the WSDL
 * - documentation: Advice | Avis
 * @subpackage Structs
 */
class Avis extends AbstractStructBase
{
    /**
     * The Customs
     * Meta information extracted from the WSDL
     * - documentation: Customs | Zollgut
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Customs;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - documentation: Terms of delivery | Frankatur
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryTerms;
    /**
     * The AdvicePhonenumber
     * Meta information extracted from the WSDL
     * - documentation: Adive phone number | Avis Telefonnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdvicePhonenumber;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment reference | Sendungsreferenz
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Reference;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * The CommercialInvoice
     * Meta information extracted from the WSDL
     * - documentation: Commercial invoice (Required for shipments outside EU) | Handelsrechnung (Pflicht bei Sendungen außerhalb der EU)
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommercialInvoice;
    /**
     * The GoodsValue
     * Meta information extracted from the WSDL
     * - documentation: Goods value (in euro) | Warenwert (in Euro)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,7}.[0-9]{2}
     * - totalDigits: 10
     * @var float
     */
    public $GoodsValue;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Consignee contact person | Ansprechpartner Empfänger
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPerson;
    /**
     * The EKAERSENTNumber
     * Meta information extracted from the WSDL
     * - documentation: EKAER-/SENT-Number (The EKAER-number is required for deliveries to Hungary. The SENT-number is required for deliveries to Poland. Both numbers are only required for special types of goods.) | EKAER-/SENT-Nummer (Die EKAER-Nummer ist
     * nötig bei Lieferungen nach Ungarn. Die SENT-Nummer ist nötig bei Lieferungen nach Polen. Beide Nummern werden nur für besondere Warenarten benötigt.)
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $EKAERSENTNumber;
    /**
     * The EKAERSENTFree
     * Meta information extracted from the WSDL
     * - documentation: EKAER/SENT free | EKAER/SENT frei
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EKAERSENTFree;
    /**
     * The ConsigneeReference
     * Meta information extracted from the WSDL
     * - documentation: Consignee Reference | Empfänger Referenz
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeReference;
    /**
     * The ShippingFreetext
     * Meta information extracted from the WSDL
     * - documentation: Shipping freetext | Versandweg Freitext
     * - base: xsd:string
     * - maxLength: 45
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingFreetext;
    /**
     * The Ordertext1
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 1 | Auftragstext 1
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext1;
    /**
     * The Ordertext2
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 2 | Auftragstext 2
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext2;
    /**
     * The Invoicetext
     * Meta information extracted from the WSDL
     * - documentation: Invoicetext | Fakturiertext
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoicetext;
    /**
     * The ProductReferenceCode
     * Meta information extracted from the WSDL
     * - documentation: Product reference code | Produkt Referenz Code
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductReferenceCode;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - documentation: Volume (in m3) | Volumen (in m3)
     * - base: xsd:decimal
     * - maxInclusive: 99.999
     * - maxOccurs: 1
     * - minInclusive: 0.000
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{3}
     * @var float
     */
    public $Volume;
    /**
     * The Loadingmeter
     * Meta information extracted from the WSDL
     * - documentation: Loadingmeter | Lademeter
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{2}
     * - totalDigits: 2
     * @var float
     */
    public $Loadingmeter;
    /**
     * The LoadingunitsFP
     * Meta information extracted from the WSDL
     * - documentation: Amount of loadingunits FP | Anzahl Ladehilfsmittel FP
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadingunitsFP;
    /**
     * The LoadingunitsGP
     * Meta information extracted from the WSDL
     * - documentation: Amount of loadingunits GP | Anzahl Ladehilfsmittel GP
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadingunitsGP;
    /**
     * Constructor method for Avis
     * @uses Avis::setCustoms()
     * @uses Avis::setDeliveryTerms()
     * @uses Avis::setAdvicePhonenumber()
     * @uses Avis::setReference()
     * @uses Avis::setAddress()
     * @uses Avis::setPosition()
     * @uses Avis::setCommercialInvoice()
     * @uses Avis::setGoodsValue()
     * @uses Avis::setContactPerson()
     * @uses Avis::setEKAERSENTNumber()
     * @uses Avis::setEKAERSENTFree()
     * @uses Avis::setConsigneeReference()
     * @uses Avis::setShippingFreetext()
     * @uses Avis::setOrdertext1()
     * @uses Avis::setOrdertext2()
     * @uses Avis::setInvoicetext()
     * @uses Avis::setProductReferenceCode()
     * @uses Avis::setVolume()
     * @uses Avis::setLoadingmeter()
     * @uses Avis::setLoadingunitsFP()
     * @uses Avis::setLoadingunitsGP()
     * @param string $customs
     * @param string $deliveryTerms
     * @param string $advicePhonenumber
     * @param string $reference
     * @param \StructType\Address $address
     * @param \StructType\Position[] $position
     * @param string $commercialInvoice
     * @param float $goodsValue
     * @param string $contactPerson
     * @param string $eKAERSENTNumber
     * @param string $eKAERSENTFree
     * @param string $consigneeReference
     * @param string $shippingFreetext
     * @param string $ordertext1
     * @param string $ordertext2
     * @param string $invoicetext
     * @param string $productReferenceCode
     * @param float $volume
     * @param float $loadingmeter
     * @param string $loadingunitsFP
     * @param string $loadingunitsGP
     */
    public function __construct($customs = null, $deliveryTerms = null, $advicePhonenumber = null, $reference = null, \StructType\Address $address = null, array $position = array(), $commercialInvoice = null, $goodsValue = null, $contactPerson = null, $eKAERSENTNumber = null, $eKAERSENTFree = null, $consigneeReference = null, $shippingFreetext = null, $ordertext1 = null, $ordertext2 = null, $invoicetext = null, $productReferenceCode = null, $volume = null, $loadingmeter = null, $loadingunitsFP = null, $loadingunitsGP = null)
    {
        $this
            ->setCustoms($customs)
            ->setDeliveryTerms($deliveryTerms)
            ->setAdvicePhonenumber($advicePhonenumber)
            ->setReference($reference)
            ->setAddress($address)
            ->setPosition($position)
            ->setCommercialInvoice($commercialInvoice)
            ->setGoodsValue($goodsValue)
            ->setContactPerson($contactPerson)
            ->setEKAERSENTNumber($eKAERSENTNumber)
            ->setEKAERSENTFree($eKAERSENTFree)
            ->setConsigneeReference($consigneeReference)
            ->setShippingFreetext($shippingFreetext)
            ->setOrdertext1($ordertext1)
            ->setOrdertext2($ordertext2)
            ->setInvoicetext($invoicetext)
            ->setProductReferenceCode($productReferenceCode)
            ->setVolume($volume)
            ->setLoadingmeter($loadingmeter)
            ->setLoadingunitsFP($loadingunitsFP)
            ->setLoadingunitsGP($loadingunitsGP);
    }
    /**
     * Get Customs value
     * @return string
     */
    public function getCustoms()
    {
        return $this->Customs;
    }
    /**
     * Set Customs value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customs
     * @return \StructType\Avis
     */
    public function setCustoms($customs = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($customs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($customs) ? implode(', ', $customs) : var_export($customs, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->Customs = $customs;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return string
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @uses \EnumType\CodelistDeliveryterms::valueIsValid()
     * @uses \EnumType\CodelistDeliveryterms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryTerms
     * @return \StructType\Avis
     */
    public function setDeliveryTerms($deliveryTerms = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistDeliveryterms::valueIsValid($deliveryTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistDeliveryterms', is_array($deliveryTerms) ? implode(', ', $deliveryTerms) : var_export($deliveryTerms, true), implode(', ', \EnumType\CodelistDeliveryterms::getValidValues())), __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Get AdvicePhonenumber value
     * @return string
     */
    public function getAdvicePhonenumber()
    {
        return $this->AdvicePhonenumber;
    }
    /**
     * Set AdvicePhonenumber value
     * @param string $advicePhonenumber
     * @return \StructType\Avis
     */
    public function setAdvicePhonenumber($advicePhonenumber = null)
    {
        // validation for constraint: string
        if (!is_null($advicePhonenumber) && !is_string($advicePhonenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advicePhonenumber, true), gettype($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($advicePhonenumber)), __LINE__);
        }
        $this->AdvicePhonenumber = $advicePhonenumber;
        return $this;
    }
    /**
     * Get Reference value
     * @return string
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\Avis
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($reference) && mb_strlen($reference) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reference) && mb_strlen($reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\Avis
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $avisPositionItem) {
            // validation for constraint: itemType
            if (!$avisPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($avisPositionItem) ? get_class($avisPositionItem) : sprintf('%s(%s)', gettype($avisPositionItem), var_export($avisPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\Avis
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($position) && count($position) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\Avis
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Position) && count($this->Position) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Position)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get CommercialInvoice value
     * @return string|null
     */
    public function getCommercialInvoice()
    {
        return $this->CommercialInvoice;
    }
    /**
     * Set CommercialInvoice value
     * @param string $commercialInvoice
     * @return \StructType\Avis
     */
    public function setCommercialInvoice($commercialInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($commercialInvoice) && !is_string($commercialInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialInvoice, true), gettype($commercialInvoice)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($commercialInvoice) && mb_strlen($commercialInvoice) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($commercialInvoice)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($commercialInvoice) && mb_strlen($commercialInvoice) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($commercialInvoice)), __LINE__);
        }
        $this->CommercialInvoice = $commercialInvoice;
        return $this;
    }
    /**
     * Get GoodsValue value
     * @return float|null
     */
    public function getGoodsValue()
    {
        return $this->GoodsValue;
    }
    /**
     * Set GoodsValue value
     * @param float $goodsValue
     * @return \StructType\Avis
     */
    public function setGoodsValue($goodsValue = null)
    {
        // validation for constraint: float
        if (!is_null($goodsValue) && !(is_float($goodsValue) || is_numeric($goodsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($goodsValue, true), gettype($goodsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($goodsValue) && mb_strlen(mb_substr($goodsValue, false !== mb_strpos($goodsValue, '.') ? mb_strpos($goodsValue, '.') + 1 : mb_strlen($goodsValue))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($goodsValue, true), mb_strlen(mb_substr($goodsValue, mb_strpos($goodsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999.99)
        if (!is_null($goodsValue) && $goodsValue > 99999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999.99', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($goodsValue) && $goodsValue < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,7}.[0-9]{2})
        if (!is_null($goodsValue) && !preg_match('/[1-9]{1}[0-9]{0,7}.[0-9]{2}/', $goodsValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,7}.[0-9]{2}', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($goodsValue) && mb_strlen(preg_replace('/(\D)/', '', $goodsValue)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($goodsValue, true), mb_strlen(preg_replace('/(\D)/', '', $goodsValue))), __LINE__);
        }
        $this->GoodsValue = $goodsValue;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @param string $contactPerson
     * @return \StructType\Avis
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contactPerson)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactPerson)), __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get EKAERSENTNumber value
     * @return string|null
     */
    public function getEKAERSENTNumber()
    {
        return $this->EKAERSENTNumber;
    }
    /**
     * Set EKAERSENTNumber value
     * @param string $eKAERSENTNumber
     * @return \StructType\Avis
     */
    public function setEKAERSENTNumber($eKAERSENTNumber = null)
    {
        // validation for constraint: string
        if (!is_null($eKAERSENTNumber) && !is_string($eKAERSENTNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eKAERSENTNumber, true), gettype($eKAERSENTNumber)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($eKAERSENTNumber) && mb_strlen($eKAERSENTNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($eKAERSENTNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($eKAERSENTNumber) && mb_strlen($eKAERSENTNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($eKAERSENTNumber)), __LINE__);
        }
        $this->EKAERSENTNumber = $eKAERSENTNumber;
        return $this;
    }
    /**
     * Get EKAERSENTFree value
     * @return string|null
     */
    public function getEKAERSENTFree()
    {
        return $this->EKAERSENTFree;
    }
    /**
     * Set EKAERSENTFree value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eKAERSENTFree
     * @return \StructType\Avis
     */
    public function setEKAERSENTFree($eKAERSENTFree = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($eKAERSENTFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($eKAERSENTFree) ? implode(', ', $eKAERSENTFree) : var_export($eKAERSENTFree, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->EKAERSENTFree = $eKAERSENTFree;
        return $this;
    }
    /**
     * Get ConsigneeReference value
     * @return string|null
     */
    public function getConsigneeReference()
    {
        return $this->ConsigneeReference;
    }
    /**
     * Set ConsigneeReference value
     * @param string $consigneeReference
     * @return \StructType\Avis
     */
    public function setConsigneeReference($consigneeReference = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeReference) && !is_string($consigneeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeReference, true), gettype($consigneeReference)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($consigneeReference) && mb_strlen($consigneeReference) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($consigneeReference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($consigneeReference) && mb_strlen($consigneeReference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($consigneeReference)), __LINE__);
        }
        $this->ConsigneeReference = $consigneeReference;
        return $this;
    }
    /**
     * Get ShippingFreetext value
     * @return string|null
     */
    public function getShippingFreetext()
    {
        return $this->ShippingFreetext;
    }
    /**
     * Set ShippingFreetext value
     * @param string $shippingFreetext
     * @return \StructType\Avis
     */
    public function setShippingFreetext($shippingFreetext = null)
    {
        // validation for constraint: string
        if (!is_null($shippingFreetext) && !is_string($shippingFreetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingFreetext, true), gettype($shippingFreetext)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($shippingFreetext) && mb_strlen($shippingFreetext) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($shippingFreetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shippingFreetext) && mb_strlen($shippingFreetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shippingFreetext)), __LINE__);
        }
        $this->ShippingFreetext = $shippingFreetext;
        return $this;
    }
    /**
     * Get Ordertext1 value
     * @return string|null
     */
    public function getOrdertext1()
    {
        return $this->Ordertext1;
    }
    /**
     * Set Ordertext1 value
     * @param string $ordertext1
     * @return \StructType\Avis
     */
    public function setOrdertext1($ordertext1 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext1) && !is_string($ordertext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext1, true), gettype($ordertext1)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext1)), __LINE__);
        }
        $this->Ordertext1 = $ordertext1;
        return $this;
    }
    /**
     * Get Ordertext2 value
     * @return string|null
     */
    public function getOrdertext2()
    {
        return $this->Ordertext2;
    }
    /**
     * Set Ordertext2 value
     * @param string $ordertext2
     * @return \StructType\Avis
     */
    public function setOrdertext2($ordertext2 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext2) && !is_string($ordertext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext2, true), gettype($ordertext2)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext2)), __LINE__);
        }
        $this->Ordertext2 = $ordertext2;
        return $this;
    }
    /**
     * Get Invoicetext value
     * @return string|null
     */
    public function getInvoicetext()
    {
        return $this->Invoicetext;
    }
    /**
     * Set Invoicetext value
     * @param string $invoicetext
     * @return \StructType\Avis
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($invoicetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoicetext)), __LINE__);
        }
        $this->Invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get ProductReferenceCode value
     * @return string|null
     */
    public function getProductReferenceCode()
    {
        return $this->ProductReferenceCode;
    }
    /**
     * Set ProductReferenceCode value
     * @param string $productReferenceCode
     * @return \StructType\Avis
     */
    public function setProductReferenceCode($productReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($productReferenceCode) && !is_string($productReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productReferenceCode, true), gettype($productReferenceCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($productReferenceCode) && mb_strlen($productReferenceCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($productReferenceCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productReferenceCode) && mb_strlen($productReferenceCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productReferenceCode)), __LINE__);
        }
        $this->ProductReferenceCode = $productReferenceCode;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\Avis
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: maxInclusive(99.999)
        if (!is_null($volume) && $volume > 99.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.999', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.000)
        if (!is_null($volume) && $volume < 0.000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{3})
        if (!is_null($volume) && !preg_match('/[0-9]{1,2}.[0-9]{3}/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{3}', var_export($volume, true)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get Loadingmeter value
     * @return float|null
     */
    public function getLoadingmeter()
    {
        return $this->Loadingmeter;
    }
    /**
     * Set Loadingmeter value
     * @param float $loadingmeter
     * @return \StructType\Avis
     */
    public function setLoadingmeter($loadingmeter = null)
    {
        // validation for constraint: float
        if (!is_null($loadingmeter) && !(is_float($loadingmeter) || is_numeric($loadingmeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadingmeter, true), gettype($loadingmeter)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(mb_substr($loadingmeter, false !== mb_strpos($loadingmeter, '.') ? mb_strpos($loadingmeter, '.') + 1 : mb_strlen($loadingmeter))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($loadingmeter, true), mb_strlen(mb_substr($loadingmeter, mb_strpos($loadingmeter, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99.99)
        if (!is_null($loadingmeter) && $loadingmeter > 99.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.99', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($loadingmeter) && $loadingmeter < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{2})
        if (!is_null($loadingmeter) && !preg_match('/[0-9]{1,2}.[0-9]{2}/', $loadingmeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{2}', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(preg_replace('/(\D)/', '', $loadingmeter)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($loadingmeter, true), mb_strlen(preg_replace('/(\D)/', '', $loadingmeter))), __LINE__);
        }
        $this->Loadingmeter = $loadingmeter;
        return $this;
    }
    /**
     * Get LoadingunitsFP value
     * @return string|null
     */
    public function getLoadingunitsFP()
    {
        return $this->LoadingunitsFP;
    }
    /**
     * Set LoadingunitsFP value
     * @param string $loadingunitsFP
     * @return \StructType\Avis
     */
    public function setLoadingunitsFP($loadingunitsFP = null)
    {
        // validation for constraint: string
        if (!is_null($loadingunitsFP) && !is_string($loadingunitsFP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingunitsFP, true), gettype($loadingunitsFP)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($loadingunitsFP) && mb_strlen($loadingunitsFP) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($loadingunitsFP)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loadingunitsFP) && mb_strlen($loadingunitsFP) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loadingunitsFP)), __LINE__);
        }
        $this->LoadingunitsFP = $loadingunitsFP;
        return $this;
    }
    /**
     * Get LoadingunitsGP value
     * @return string|null
     */
    public function getLoadingunitsGP()
    {
        return $this->LoadingunitsGP;
    }
    /**
     * Set LoadingunitsGP value
     * @param string $loadingunitsGP
     * @return \StructType\Avis
     */
    public function setLoadingunitsGP($loadingunitsGP = null)
    {
        // validation for constraint: string
        if (!is_null($loadingunitsGP) && !is_string($loadingunitsGP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingunitsGP, true), gettype($loadingunitsGP)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($loadingunitsGP) && mb_strlen($loadingunitsGP) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($loadingunitsGP)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loadingunitsGP) && mb_strlen($loadingunitsGP) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loadingunitsGP)), __LINE__);
        }
        $this->LoadingunitsGP = $loadingunitsGP;
        return $this;
    }
}
