<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArticleDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Article information | Artikelinformationen
 * @subpackage Structs
 */
class ArticleDetails extends AbstractStructBase
{
    /**
     * The PackageAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount of packages | Packstückanzahl
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageAmount;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Length (in cm) | Länge (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{2}
     * - totalDigits: 7
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Width (in cm) | Breite (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{2}
     * - totalDigits: 7
     * @var float
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Height (in cm) | Höhe (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{2}
     * - totalDigits: 7
     * @var float
     */
    public $Height;
    /**
     * Constructor method for ArticleDetails
     * @uses ArticleDetails::setPackageAmount()
     * @uses ArticleDetails::setLength()
     * @uses ArticleDetails::setWidth()
     * @uses ArticleDetails::setHeight()
     * @param string $packageAmount
     * @param float $length
     * @param float $width
     * @param float $height
     */
    public function __construct($packageAmount = null, $length = null, $width = null, $height = null)
    {
        $this
            ->setPackageAmount($packageAmount)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get PackageAmount value
     * @return string
     */
    public function getPackageAmount()
    {
        return $this->PackageAmount;
    }
    /**
     * Set PackageAmount value
     * @param string $packageAmount
     * @return \StructType\ArticleDetails
     */
    public function setPackageAmount($packageAmount = null)
    {
        // validation for constraint: string
        if (!is_null($packageAmount) && !is_string($packageAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageAmount, true), gettype($packageAmount)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageAmount)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageAmount)), __LINE__);
        }
        $this->PackageAmount = $packageAmount;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\ArticleDetails
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($length) && mb_strlen(mb_substr($length, false !== mb_strpos($length, '.') ? mb_strpos($length, '.') + 1 : mb_strlen($length))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.99)
        if (!is_null($length) && $length > 99999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.99', var_export($length, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($length) && $length < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($length, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{2})
        if (!is_null($length) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{2}/', $length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{2}', var_export($length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\ArticleDetails
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.99)
        if (!is_null($width) && $width > 99999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.99', var_export($width, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($width) && $width < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($width, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{2})
        if (!is_null($width) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{2}/', $width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{2}', var_export($width, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\ArticleDetails
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.99)
        if (!is_null($height) && $height > 99999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.99', var_export($height, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($height) && $height < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($height, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{2})
        if (!is_null($height) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{2}/', $height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{2}', var_export($height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
}
