<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validation ServiceType
 * @subpackage Services
 */
class Validation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShipmentValidation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentValidationRequest $shipmentValidationRequest
     * @return \StructType\ShipmentValidationResponse|bool
     */
    public function ShipmentValidation(\StructType\ShipmentValidationRequest $shipmentValidationRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ShipmentValidation($shipmentValidationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShipmentValidationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
