<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Documents ServiceType
 * @subpackage Services
 */
class Documents extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Documents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DocumentsRequest $documentsRequest
     * @return \StructType\DocumentsResponse|bool
     */
    public function Documents(\StructType\DocumentsRequest $documentsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->Documents($documentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DocumentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
