<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Positions StructType
 * @subpackage Structs
 */
class Positions extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * Constructor method for Positions
     * @uses Positions::setPosition()
     * @param \StructType\Position[] $position
     */
    public function __construct(array $position = array())
    {
        $this
            ->setPosition($position);
    }
    /**
     * Get Position value
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionsPositionItem) {
            // validation for constraint: itemType
            if (!$positionsPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($positionsPositionItem) ? get_class($positionsPositionItem) : sprintf('%s(%s)', gettype($positionsPositionItem), var_export($positionsPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\Positions
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($position) && count($position) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\Positions
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Position) && count($this->Position) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Position)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
}
