<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Shipment position | Sendungsposition
 * @subpackage Structs
 */
class PositionDetails extends AbstractStructBase
{
    /**
     * The PackageAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount of packages | Packstückanzahl
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageAmount;
    /**
     * The PackageType
     * Meta information extracted from the WSDL
     * - documentation: Type of package | Verpackungsart
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PackageType;
    /**
     * The GoodsDescription
     * Meta information extracted from the WSDL
     * - documentation: Goods description | Inhalt
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $GoodsDescription;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Gross weight (in kg) | Bruttogewicht (in kg)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 1
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{2}
     * - totalDigits: 7
     * @var float
     */
    public $GrossWeight;
    /**
     * The MarksNumbers
     * Meta information extracted from the WSDL
     * - documentation: Marks / Numbers | Zeichen / Nummer
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarksNumbers;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Length (in cm) | Länge (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxInclusive: 99999.9
     * - maxOccurs: 1
     * - minInclusive: 0.0
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{1}
     * - totalDigits: 6
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Width (in cm) | Breite (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxInclusive: 99999.9
     * - maxOccurs: 1
     * - minInclusive: 0.0
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{1}
     * - totalDigits: 6
     * @var float
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Height (in cm) | Höhe (in cm)
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxInclusive: 99999.9
     * - maxOccurs: 1
     * - minInclusive: 0.0
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,4}.[0-9]{1}
     * - totalDigits: 6
     * @var float
     */
    public $Height;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - documentation: Volume (in cbm) | Volumen (in cbm)
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxInclusive: 999999999.999
     * - maxOccurs: 1
     * - minInclusive: 0.0
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,8}.[0-9]{3}
     * - totalDigits: 12
     * @var float
     */
    public $Volume;
    /**
     * Constructor method for PositionDetails
     * @uses PositionDetails::setPackageAmount()
     * @uses PositionDetails::setPackageType()
     * @uses PositionDetails::setGoodsDescription()
     * @uses PositionDetails::setGrossWeight()
     * @uses PositionDetails::setMarksNumbers()
     * @uses PositionDetails::setLength()
     * @uses PositionDetails::setWidth()
     * @uses PositionDetails::setHeight()
     * @uses PositionDetails::setVolume()
     * @param string $packageAmount
     * @param string $packageType
     * @param string $goodsDescription
     * @param float $grossWeight
     * @param string $marksNumbers
     * @param float $length
     * @param float $width
     * @param float $height
     * @param float $volume
     */
    public function __construct($packageAmount = null, $packageType = null, $goodsDescription = null, $grossWeight = null, $marksNumbers = null, $length = null, $width = null, $height = null, $volume = null)
    {
        $this
            ->setPackageAmount($packageAmount)
            ->setPackageType($packageType)
            ->setGoodsDescription($goodsDescription)
            ->setGrossWeight($grossWeight)
            ->setMarksNumbers($marksNumbers)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setVolume($volume);
    }
    /**
     * Get PackageAmount value
     * @return string
     */
    public function getPackageAmount()
    {
        return $this->PackageAmount;
    }
    /**
     * Set PackageAmount value
     * @param string $packageAmount
     * @return \StructType\PositionDetails
     */
    public function setPackageAmount($packageAmount = null)
    {
        // validation for constraint: string
        if (!is_null($packageAmount) && !is_string($packageAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageAmount, true), gettype($packageAmount)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageAmount)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageAmount) && mb_strlen($packageAmount) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageAmount)), __LINE__);
        }
        $this->PackageAmount = $packageAmount;
        return $this;
    }
    /**
     * Get PackageType value
     * @return string
     */
    public function getPackageType()
    {
        return $this->PackageType;
    }
    /**
     * Set PackageType value
     * @uses \EnumType\CodelistPackagecodes::valueIsValid()
     * @uses \EnumType\CodelistPackagecodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageType
     * @return \StructType\PositionDetails
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistPackagecodes::valueIsValid($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistPackagecodes', is_array($packageType) ? implode(', ', $packageType) : var_export($packageType, true), implode(', ', \EnumType\CodelistPackagecodes::getValidValues())), __LINE__);
        }
        $this->PackageType = $packageType;
        return $this;
    }
    /**
     * Get GoodsDescription value
     * @return string
     */
    public function getGoodsDescription()
    {
        return $this->GoodsDescription;
    }
    /**
     * Set GoodsDescription value
     * @param string $goodsDescription
     * @return \StructType\PositionDetails
     */
    public function setGoodsDescription($goodsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($goodsDescription) && !is_string($goodsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsDescription, true), gettype($goodsDescription)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($goodsDescription) && mb_strlen($goodsDescription) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($goodsDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($goodsDescription) && mb_strlen($goodsDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($goodsDescription)), __LINE__);
        }
        $this->GoodsDescription = $goodsDescription;
        return $this;
    }
    /**
     * Get GrossWeight value
     * @return float
     */
    public function getGrossWeight()
    {
        return $this->GrossWeight;
    }
    /**
     * Set GrossWeight value
     * @param float $grossWeight
     * @return \StructType\PositionDetails
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.99)
        if (!is_null($grossWeight) && $grossWeight > 99999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.99', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($grossWeight) && $grossWeight < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{2})
        if (!is_null($grossWeight) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{2}/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{2}', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->GrossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get MarksNumbers value
     * @return string|null
     */
    public function getMarksNumbers()
    {
        return $this->MarksNumbers;
    }
    /**
     * Set MarksNumbers value
     * @param string $marksNumbers
     * @return \StructType\PositionDetails
     */
    public function setMarksNumbers($marksNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($marksNumbers) && !is_string($marksNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marksNumbers, true), gettype($marksNumbers)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($marksNumbers) && mb_strlen($marksNumbers) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($marksNumbers)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($marksNumbers) && mb_strlen($marksNumbers) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($marksNumbers)), __LINE__);
        }
        $this->MarksNumbers = $marksNumbers;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\PositionDetails
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($length) && mb_strlen(mb_substr($length, false !== mb_strpos($length, '.') ? mb_strpos($length, '.') + 1 : mb_strlen($length))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.9)
        if (!is_null($length) && $length > 99999.9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.9', var_export($length, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($length) && $length < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($length, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{1})
        if (!is_null($length) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{1}/', $length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{1}', var_export($length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\PositionDetails
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.9)
        if (!is_null($width) && $width > 99999.9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.9', var_export($width, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($width) && $width < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($width, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{1})
        if (!is_null($width) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{1}/', $width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{1}', var_export($width, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\PositionDetails
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999.9)
        if (!is_null($height) && $height > 99999.9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999.9', var_export($height, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($height) && $height < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($height, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,4}.[0-9]{1})
        if (!is_null($height) && !preg_match('/[1-9]{1}[0-9]{0,4}.[0-9]{1}/', $height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,4}.[0-9]{1}', var_export($height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\PositionDetails
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($volume) && mb_strlen(mb_substr($volume, false !== mb_strpos($volume, '.') ? mb_strpos($volume, '.') + 1 : mb_strlen($volume))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($volume, true), mb_strlen(mb_substr($volume, mb_strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(999999999.999)
        if (!is_null($volume) && $volume > 999999999.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999999.999', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($volume) && $volume < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,8}.[0-9]{3})
        if (!is_null($volume) && !preg_match('/[1-9]{1}[0-9]{0,8}.[0-9]{3}/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,8}.[0-9]{3}', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($volume) && mb_strlen(preg_replace('/(\D)/', '', $volume)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($volume, true), mb_strlen(preg_replace('/(\D)/', '', $volume))), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
}
