<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position StructType
 * @subpackage Structs
 */
class Position extends AbstractStructBase
{
    /**
     * The PositionDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PositionDetails
     */
    public $PositionDetails;
    /**
     * The Articles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Articles[]
     */
    public $Articles;
    /**
     * The Dangerousgoods
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Dangerousgoods[]
     */
    public $Dangerousgoods;
    /**
     * The NVE
     * Meta information extracted from the WSDL
     * - documentation: NVE
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: unbounded
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NVE;
    /**
     * Constructor method for Position
     * @uses Position::setPositionDetails()
     * @uses Position::setArticles()
     * @uses Position::setDangerousgoods()
     * @uses Position::setNVE()
     * @param \StructType\PositionDetails $positionDetails
     * @param \StructType\Articles[] $articles
     * @param \StructType\Dangerousgoods[] $dangerousgoods
     * @param string[] $nVE
     */
    public function __construct(\StructType\PositionDetails $positionDetails = null, array $articles = array(), array $dangerousgoods = array(), array $nVE = array())
    {
        $this
            ->setPositionDetails($positionDetails)
            ->setArticles($articles)
            ->setDangerousgoods($dangerousgoods)
            ->setNVE($nVE);
    }
    /**
     * Get PositionDetails value
     * @return \StructType\PositionDetails
     */
    public function getPositionDetails()
    {
        return $this->PositionDetails;
    }
    /**
     * Set PositionDetails value
     * @param \StructType\PositionDetails $positionDetails
     * @return \StructType\Position
     */
    public function setPositionDetails(\StructType\PositionDetails $positionDetails = null)
    {
        $this->PositionDetails = $positionDetails;
        return $this;
    }
    /**
     * Get Articles value
     * @return \StructType\Articles[]|null
     */
    public function getArticles()
    {
        return $this->Articles;
    }
    /**
     * This method is responsible for validating the values passed to the setArticles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArticles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArticlesForArrayConstraintsFromSetArticles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionArticlesItem) {
            // validation for constraint: itemType
            if (!$positionArticlesItem instanceof \StructType\Articles) {
                $invalidValues[] = is_object($positionArticlesItem) ? get_class($positionArticlesItem) : sprintf('%s(%s)', gettype($positionArticlesItem), var_export($positionArticlesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Articles property can only contain items of type \StructType\Articles, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Articles value
     * @throws \InvalidArgumentException
     * @param \StructType\Articles[] $articles
     * @return \StructType\Position
     */
    public function setArticles(array $articles = array())
    {
        // validation for constraint: array
        if ('' !== ($articlesArrayErrorMessage = self::validateArticlesForArrayConstraintsFromSetArticles($articles))) {
            throw new \InvalidArgumentException($articlesArrayErrorMessage, __LINE__);
        }
        $this->Articles = $articles;
        return $this;
    }
    /**
     * Add item to Articles value
     * @throws \InvalidArgumentException
     * @param \StructType\Articles $item
     * @return \StructType\Position
     */
    public function addToArticles(\StructType\Articles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Articles) {
            throw new \InvalidArgumentException(sprintf('The Articles property can only contain items of type \StructType\Articles, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Articles[] = $item;
        return $this;
    }
    /**
     * Get Dangerousgoods value
     * @return \StructType\Dangerousgoods[]|null
     */
    public function getDangerousgoods()
    {
        return $this->Dangerousgoods;
    }
    /**
     * This method is responsible for validating the values passed to the setDangerousgoods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDangerousgoods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDangerousgoodsForArrayConstraintsFromSetDangerousgoods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionDangerousgoodsItem) {
            // validation for constraint: itemType
            if (!$positionDangerousgoodsItem instanceof \StructType\Dangerousgoods) {
                $invalidValues[] = is_object($positionDangerousgoodsItem) ? get_class($positionDangerousgoodsItem) : sprintf('%s(%s)', gettype($positionDangerousgoodsItem), var_export($positionDangerousgoodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dangerousgoods property can only contain items of type \StructType\Dangerousgoods, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dangerousgoods value
     * @throws \InvalidArgumentException
     * @param \StructType\Dangerousgoods[] $dangerousgoods
     * @return \StructType\Position
     */
    public function setDangerousgoods(array $dangerousgoods = array())
    {
        // validation for constraint: array
        if ('' !== ($dangerousgoodsArrayErrorMessage = self::validateDangerousgoodsForArrayConstraintsFromSetDangerousgoods($dangerousgoods))) {
            throw new \InvalidArgumentException($dangerousgoodsArrayErrorMessage, __LINE__);
        }
        $this->Dangerousgoods = $dangerousgoods;
        return $this;
    }
    /**
     * Add item to Dangerousgoods value
     * @throws \InvalidArgumentException
     * @param \StructType\Dangerousgoods $item
     * @return \StructType\Position
     */
    public function addToDangerousgoods(\StructType\Dangerousgoods $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dangerousgoods) {
            throw new \InvalidArgumentException(sprintf('The Dangerousgoods property can only contain items of type \StructType\Dangerousgoods, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dangerousgoods[] = $item;
        return $this;
    }
    /**
     * Get NVE value
     * @return string[]|null
     */
    public function getNVE()
    {
        return $this->NVE;
    }
    /**
     * This method is responsible for validating the values passed to the setNVE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNVE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNVEForArrayConstraintsFromSetNVE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionNVEItem) {
            // validation for constraint: itemType
            if (!is_string($positionNVEItem)) {
                $invalidValues[] = is_object($positionNVEItem) ? get_class($positionNVEItem) : sprintf('%s(%s)', gettype($positionNVEItem), var_export($positionNVEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NVE property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNVE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNVE method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNVEForMaxLengthConstraintFromSetNVE($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionNVEItem) {
            // validation for constraint: maxLength(255)
            if (mb_strlen($positionNVEItem) > 255) {
                $invalidValues[] = var_export($positionNVEItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 255', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setNVE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNVE method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNVEForMinLengthConstraintFromSetNVE($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $positionNVEItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($positionNVEItem) < 1) {
                $invalidValues[] = var_export($positionNVEItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NVE value
     * @throws \InvalidArgumentException
     * @param string[] $nVE
     * @return \StructType\Position
     */
    public function setNVE(array $nVE = array())
    {
        // validation for constraint: array
        if ('' !== ($nVEArrayErrorMessage = self::validateNVEForArrayConstraintsFromSetNVE($nVE))) {
            throw new \InvalidArgumentException($nVEArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if ('' !== ($nVEMaxLengthErrorMessage = self::validateNVEForMaxLengthConstraintFromSetNVE($nVE))) {
            throw new \InvalidArgumentException($nVEMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($nVEMinLengthErrorMessage = self::validateNVEForMinLengthConstraintFromSetNVE($nVE))) {
            throw new \InvalidArgumentException($nVEMinLengthErrorMessage, __LINE__);
        }
        $this->NVE = $nVE;
        return $this;
    }
    /**
     * Add item to NVE value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Position
     */
    public function addToNVE($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NVE property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (mb_strlen($item) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->NVE[] = $item;
        return $this;
    }
}
