<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pickup StructType
 * Meta information extracted from the WSDL
 * - documentation: Pickup order | Abholauftrag
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * The RequestedPickupdate
     * Meta information extracted from the WSDL
     * - documentation: Requested pickup date | Gewünschtes Abholdatum
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $RequestedPickupdate;
    /**
     * The Ordertext1
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 1 | Abholhinweis 1
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext1;
    /**
     * The Ordertext2
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 2 | Abholhinweis 2
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext2;
    /**
     * The Loadingmeter
     * Meta information extracted from the WSDL
     * - documentation: Loadingmeter | Lademeter
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{2}
     * - totalDigits: 2
     * @var float
     */
    public $Loadingmeter;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - documentation: Volume (in m3) | Volumen (in m3)
     * - base: xsd:decimal
     * - maxInclusive: 99.999
     * - maxOccurs: 1
     * - minInclusive: 0.000
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{3}
     * @var float
     */
    public $Volume;
    /**
     * Constructor method for Pickup
     * @uses Pickup::setPosition()
     * @uses Pickup::setRequestedPickupdate()
     * @uses Pickup::setOrdertext1()
     * @uses Pickup::setOrdertext2()
     * @uses Pickup::setLoadingmeter()
     * @uses Pickup::setVolume()
     * @param \StructType\Position[] $position
     * @param string $requestedPickupdate
     * @param string $ordertext1
     * @param string $ordertext2
     * @param float $loadingmeter
     * @param float $volume
     */
    public function __construct(array $position = array(), $requestedPickupdate = null, $ordertext1 = null, $ordertext2 = null, $loadingmeter = null, $volume = null)
    {
        $this
            ->setPosition($position)
            ->setRequestedPickupdate($requestedPickupdate)
            ->setOrdertext1($ordertext1)
            ->setOrdertext2($ordertext2)
            ->setLoadingmeter($loadingmeter)
            ->setVolume($volume);
    }
    /**
     * Get Position value
     * @return \StructType\Position[]
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pickupPositionItem) {
            // validation for constraint: itemType
            if (!$pickupPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($pickupPositionItem) ? get_class($pickupPositionItem) : sprintf('%s(%s)', gettype($pickupPositionItem), var_export($pickupPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\Pickup
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($position) && count($position) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\Pickup
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Position) && count($this->Position) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Position)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get RequestedPickupdate value
     * @return string|null
     */
    public function getRequestedPickupdate()
    {
        return $this->RequestedPickupdate;
    }
    /**
     * Set RequestedPickupdate value
     * @param string $requestedPickupdate
     * @return \StructType\Pickup
     */
    public function setRequestedPickupdate($requestedPickupdate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedPickupdate) && !is_string($requestedPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedPickupdate, true), gettype($requestedPickupdate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($requestedPickupdate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $requestedPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($requestedPickupdate, true)), __LINE__);
        }
        $this->RequestedPickupdate = $requestedPickupdate;
        return $this;
    }
    /**
     * Get Ordertext1 value
     * @return string|null
     */
    public function getOrdertext1()
    {
        return $this->Ordertext1;
    }
    /**
     * Set Ordertext1 value
     * @param string $ordertext1
     * @return \StructType\Pickup
     */
    public function setOrdertext1($ordertext1 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext1) && !is_string($ordertext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext1, true), gettype($ordertext1)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext1)), __LINE__);
        }
        $this->Ordertext1 = $ordertext1;
        return $this;
    }
    /**
     * Get Ordertext2 value
     * @return string|null
     */
    public function getOrdertext2()
    {
        return $this->Ordertext2;
    }
    /**
     * Set Ordertext2 value
     * @param string $ordertext2
     * @return \StructType\Pickup
     */
    public function setOrdertext2($ordertext2 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext2) && !is_string($ordertext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext2, true), gettype($ordertext2)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext2)), __LINE__);
        }
        $this->Ordertext2 = $ordertext2;
        return $this;
    }
    /**
     * Get Loadingmeter value
     * @return float|null
     */
    public function getLoadingmeter()
    {
        return $this->Loadingmeter;
    }
    /**
     * Set Loadingmeter value
     * @param float $loadingmeter
     * @return \StructType\Pickup
     */
    public function setLoadingmeter($loadingmeter = null)
    {
        // validation for constraint: float
        if (!is_null($loadingmeter) && !(is_float($loadingmeter) || is_numeric($loadingmeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadingmeter, true), gettype($loadingmeter)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(mb_substr($loadingmeter, false !== mb_strpos($loadingmeter, '.') ? mb_strpos($loadingmeter, '.') + 1 : mb_strlen($loadingmeter))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($loadingmeter, true), mb_strlen(mb_substr($loadingmeter, mb_strpos($loadingmeter, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99.99)
        if (!is_null($loadingmeter) && $loadingmeter > 99.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.99', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($loadingmeter) && $loadingmeter < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{2})
        if (!is_null($loadingmeter) && !preg_match('/[0-9]{1,2}.[0-9]{2}/', $loadingmeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{2}', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(preg_replace('/(\D)/', '', $loadingmeter)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($loadingmeter, true), mb_strlen(preg_replace('/(\D)/', '', $loadingmeter))), __LINE__);
        }
        $this->Loadingmeter = $loadingmeter;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\Pickup
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: maxInclusive(99.999)
        if (!is_null($volume) && $volume > 99.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.999', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.000)
        if (!is_null($volume) && $volume < 0.000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{3})
        if (!is_null($volume) && !preg_match('/[0-9]{1,2}.[0-9]{3}/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{3}', var_export($volume, true)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
}
