<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InboundInternational StructType
 * Meta information extracted from the WSDL
 * - documentation: Inbound shipment international (pickup not DE) | Einzug international (nur Abholadressen ungleich DE)
 * @subpackage Structs
 */
class InboundInternational extends AbstractStructBase
{
    /**
     * The LatestPickupdate
     * Meta information extracted from the WSDL
     * - documentation: Latest Pickupdate | SpätestesAbholdatum
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $LatestPickupdate;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - documentation: Terms of delivery | Frankatur
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryTerms;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment reference | Sendungsreferenz
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Reference;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * The Pickupdate
     * Meta information extracted from the WSDL
     * - documentation: Pickupdate | Abholdatum
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $Pickupdate;
    /**
     * The EarliestPickupdate
     * Meta information extracted from the WSDL
     * - documentation: Earliest Pickupdate | Frühestes Abholdatum
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $EarliestPickupdate;
    /**
     * The Pickuptime
     * Meta information extracted from the WSDL
     * - documentation: Pickuptime | Abholuhrzeit
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]
     * @var string
     */
    public $Pickuptime;
    /**
     * The CollectionPickuptimeFrom
     * Meta information extracted from the WSDL
     * - documentation: Pickuptime from | Abholuhrzeit von
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]
     * @var string
     */
    public $CollectionPickuptimeFrom;
    /**
     * The Fddboolean
     * Meta information extracted from the WSDL
     * - documentation: FixedDeliveryDate Y/N (checkbox07) | FixedDeliveryDate J/N (checkbox07)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fddboolean;
    /**
     * The CollectionPickuptimeTo
     * Meta information extracted from the WSDL
     * - documentation: Pickuptime to | Abholuhrzeit bis
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]
     * @var string
     */
    public $CollectionPickuptimeTo;
    /**
     * The PickupdateSpecification
     * Meta information extracted from the WSDL
     * - documentation: Pickupdate specification | Abholdatum Kennzeichen
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PickupdateSpecification;
    /**
     * The Deliverydate
     * Meta information extracted from the WSDL
     * - documentation: Deliverydate | Zustelldatum | FDD Deliverydate (to be used only with FDDboolean = true) | FDD Zustelldatum (nur mit FDDboolean = true zu nutzen)
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $Deliverydate;
    /**
     * The AdvicePhonenumber
     * Meta information extracted from the WSDL
     * - documentation: GoodsDescription for international pickup | Warenbezeichnung fuer internationale Einzuege
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvicePhonenumber;
    /**
     * The GoodsValue
     * Meta information extracted from the WSDL
     * - documentation: Goods value (in euro) | Warenwert (in Euro)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,9}.[0-9]{2}
     * - totalDigits: 12
     * @var float
     */
    public $GoodsValue;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Consignee contact person | Ansprechpartner Empfänger
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPerson;
    /**
     * The Pickuptext1
     * Meta information extracted from the WSDL
     * - documentation: Pickuptext 1 | Einzugstext 1
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pickuptext1;
    /**
     * The Pickuptext2
     * Meta information extracted from the WSDL
     * - documentation: Pickuptext 2 | Einzugstext 2
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pickuptext2;
    /**
     * The Pickuptext3
     * Meta information extracted from the WSDL
     * - documentation: Pickuptext 3 | Einzugstext 3
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pickuptext3;
    /**
     * The Ordertext1
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 1 | Auftragstext 1
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext1;
    /**
     * The Ordertext2
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 2 | Auftragstext 2
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext2;
    /**
     * The Invoicetext
     * Meta information extracted from the WSDL
     * - documentation: Invoicetext | Fakturiertext
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoicetext;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - documentation: Volume (in m3) | Volumen (in m3)
     * - base: xsd:decimal
     * - maxInclusive: 99.999
     * - maxOccurs: 1
     * - minInclusive: 0.000
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{3}
     * @var float
     */
    public $Volume;
    /**
     * The Loadingmeter
     * Meta information extracted from the WSDL
     * - documentation: Loadingmeter | Lademeter
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{2}
     * - totalDigits: 2
     * @var float
     */
    public $Loadingmeter;
    /**
     * Constructor method for InboundInternational
     * @uses InboundInternational::setLatestPickupdate()
     * @uses InboundInternational::setDeliveryTerms()
     * @uses InboundInternational::setReference()
     * @uses InboundInternational::setAddress()
     * @uses InboundInternational::setPosition()
     * @uses InboundInternational::setPickupdate()
     * @uses InboundInternational::setEarliestPickupdate()
     * @uses InboundInternational::setPickuptime()
     * @uses InboundInternational::setCollectionPickuptimeFrom()
     * @uses InboundInternational::setFddboolean()
     * @uses InboundInternational::setCollectionPickuptimeTo()
     * @uses InboundInternational::setPickupdateSpecification()
     * @uses InboundInternational::setDeliverydate()
     * @uses InboundInternational::setAdvicePhonenumber()
     * @uses InboundInternational::setGoodsValue()
     * @uses InboundInternational::setContactPerson()
     * @uses InboundInternational::setPickuptext1()
     * @uses InboundInternational::setPickuptext2()
     * @uses InboundInternational::setPickuptext3()
     * @uses InboundInternational::setOrdertext1()
     * @uses InboundInternational::setOrdertext2()
     * @uses InboundInternational::setInvoicetext()
     * @uses InboundInternational::setVolume()
     * @uses InboundInternational::setLoadingmeter()
     * @param string $latestPickupdate
     * @param string $deliveryTerms
     * @param string $reference
     * @param \StructType\Address $address
     * @param \StructType\Position[] $position
     * @param string $pickupdate
     * @param string $earliestPickupdate
     * @param string $pickuptime
     * @param string $collectionPickuptimeFrom
     * @param string $fddboolean
     * @param string $collectionPickuptimeTo
     * @param string $pickupdateSpecification
     * @param string $deliverydate
     * @param string $advicePhonenumber
     * @param float $goodsValue
     * @param string $contactPerson
     * @param string $pickuptext1
     * @param string $pickuptext2
     * @param string $pickuptext3
     * @param string $ordertext1
     * @param string $ordertext2
     * @param string $invoicetext
     * @param float $volume
     * @param float $loadingmeter
     */
    public function __construct($latestPickupdate = null, $deliveryTerms = null, $reference = null, \StructType\Address $address = null, array $position = array(), $pickupdate = null, $earliestPickupdate = null, $pickuptime = null, $collectionPickuptimeFrom = null, $fddboolean = null, $collectionPickuptimeTo = null, $pickupdateSpecification = null, $deliverydate = null, $advicePhonenumber = null, $goodsValue = null, $contactPerson = null, $pickuptext1 = null, $pickuptext2 = null, $pickuptext3 = null, $ordertext1 = null, $ordertext2 = null, $invoicetext = null, $volume = null, $loadingmeter = null)
    {
        $this
            ->setLatestPickupdate($latestPickupdate)
            ->setDeliveryTerms($deliveryTerms)
            ->setReference($reference)
            ->setAddress($address)
            ->setPosition($position)
            ->setPickupdate($pickupdate)
            ->setEarliestPickupdate($earliestPickupdate)
            ->setPickuptime($pickuptime)
            ->setCollectionPickuptimeFrom($collectionPickuptimeFrom)
            ->setFddboolean($fddboolean)
            ->setCollectionPickuptimeTo($collectionPickuptimeTo)
            ->setPickupdateSpecification($pickupdateSpecification)
            ->setDeliverydate($deliverydate)
            ->setAdvicePhonenumber($advicePhonenumber)
            ->setGoodsValue($goodsValue)
            ->setContactPerson($contactPerson)
            ->setPickuptext1($pickuptext1)
            ->setPickuptext2($pickuptext2)
            ->setPickuptext3($pickuptext3)
            ->setOrdertext1($ordertext1)
            ->setOrdertext2($ordertext2)
            ->setInvoicetext($invoicetext)
            ->setVolume($volume)
            ->setLoadingmeter($loadingmeter);
    }
    /**
     * Get LatestPickupdate value
     * @return string
     */
    public function getLatestPickupdate()
    {
        return $this->LatestPickupdate;
    }
    /**
     * Set LatestPickupdate value
     * @param string $latestPickupdate
     * @return \StructType\InboundInternational
     */
    public function setLatestPickupdate($latestPickupdate = null)
    {
        // validation for constraint: string
        if (!is_null($latestPickupdate) && !is_string($latestPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestPickupdate, true), gettype($latestPickupdate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($latestPickupdate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $latestPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($latestPickupdate, true)), __LINE__);
        }
        $this->LatestPickupdate = $latestPickupdate;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return string
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @uses \EnumType\CodelistDeliveryterms::valueIsValid()
     * @uses \EnumType\CodelistDeliveryterms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryTerms
     * @return \StructType\InboundInternational
     */
    public function setDeliveryTerms($deliveryTerms = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistDeliveryterms::valueIsValid($deliveryTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistDeliveryterms', is_array($deliveryTerms) ? implode(', ', $deliveryTerms) : var_export($deliveryTerms, true), implode(', ', \EnumType\CodelistDeliveryterms::getValidValues())), __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Get Reference value
     * @return string
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\InboundInternational
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($reference) && mb_strlen($reference) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reference) && mb_strlen($reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\InboundInternational
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inboundInternationalPositionItem) {
            // validation for constraint: itemType
            if (!$inboundInternationalPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($inboundInternationalPositionItem) ? get_class($inboundInternationalPositionItem) : sprintf('%s(%s)', gettype($inboundInternationalPositionItem), var_export($inboundInternationalPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\InboundInternational
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($position) && count($position) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\InboundInternational
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Position) && count($this->Position) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Position)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get Pickupdate value
     * @return string
     */
    public function getPickupdate()
    {
        return $this->Pickupdate;
    }
    /**
     * Set Pickupdate value
     * @param string $pickupdate
     * @return \StructType\InboundInternational
     */
    public function setPickupdate($pickupdate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupdate) && !is_string($pickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupdate, true), gettype($pickupdate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($pickupdate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $pickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($pickupdate, true)), __LINE__);
        }
        $this->Pickupdate = $pickupdate;
        return $this;
    }
    /**
     * Get EarliestPickupdate value
     * @return string|null
     */
    public function getEarliestPickupdate()
    {
        return $this->EarliestPickupdate;
    }
    /**
     * Set EarliestPickupdate value
     * @param string $earliestPickupdate
     * @return \StructType\InboundInternational
     */
    public function setEarliestPickupdate($earliestPickupdate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestPickupdate) && !is_string($earliestPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestPickupdate, true), gettype($earliestPickupdate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($earliestPickupdate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $earliestPickupdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($earliestPickupdate, true)), __LINE__);
        }
        $this->EarliestPickupdate = $earliestPickupdate;
        return $this;
    }
    /**
     * Get Pickuptime value
     * @return string|null
     */
    public function getPickuptime()
    {
        return $this->Pickuptime;
    }
    /**
     * Set Pickuptime value
     * @param string $pickuptime
     * @return \StructType\InboundInternational
     */
    public function setPickuptime($pickuptime = null)
    {
        // validation for constraint: string
        if (!is_null($pickuptime) && !is_string($pickuptime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickuptime, true), gettype($pickuptime)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($pickuptime) && !preg_match('/([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]/', $pickuptime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]', var_export($pickuptime, true)), __LINE__);
        }
        $this->Pickuptime = $pickuptime;
        return $this;
    }
    /**
     * Get CollectionPickuptimeFrom value
     * @return string|null
     */
    public function getCollectionPickuptimeFrom()
    {
        return $this->CollectionPickuptimeFrom;
    }
    /**
     * Set CollectionPickuptimeFrom value
     * @param string $collectionPickuptimeFrom
     * @return \StructType\InboundInternational
     */
    public function setCollectionPickuptimeFrom($collectionPickuptimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($collectionPickuptimeFrom) && !is_string($collectionPickuptimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionPickuptimeFrom, true), gettype($collectionPickuptimeFrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($collectionPickuptimeFrom) && !preg_match('/([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]/', $collectionPickuptimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]', var_export($collectionPickuptimeFrom, true)), __LINE__);
        }
        $this->CollectionPickuptimeFrom = $collectionPickuptimeFrom;
        return $this;
    }
    /**
     * Get Fddboolean value
     * @return string|null
     */
    public function getFddboolean()
    {
        return $this->Fddboolean;
    }
    /**
     * Set Fddboolean value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fddboolean
     * @return \StructType\InboundInternational
     */
    public function setFddboolean($fddboolean = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($fddboolean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($fddboolean) ? implode(', ', $fddboolean) : var_export($fddboolean, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->Fddboolean = $fddboolean;
        return $this;
    }
    /**
     * Get CollectionPickuptimeTo value
     * @return string|null
     */
    public function getCollectionPickuptimeTo()
    {
        return $this->CollectionPickuptimeTo;
    }
    /**
     * Set CollectionPickuptimeTo value
     * @param string $collectionPickuptimeTo
     * @return \StructType\InboundInternational
     */
    public function setCollectionPickuptimeTo($collectionPickuptimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($collectionPickuptimeTo) && !is_string($collectionPickuptimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionPickuptimeTo, true), gettype($collectionPickuptimeTo)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($collectionPickuptimeTo) && !preg_match('/([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]/', $collectionPickuptimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]', var_export($collectionPickuptimeTo, true)), __LINE__);
        }
        $this->CollectionPickuptimeTo = $collectionPickuptimeTo;
        return $this;
    }
    /**
     * Get PickupdateSpecification value
     * @return string|null
     */
    public function getPickupdateSpecification()
    {
        return $this->PickupdateSpecification;
    }
    /**
     * Set PickupdateSpecification value
     * @uses \EnumType\CodelistDateSpecification::valueIsValid()
     * @uses \EnumType\CodelistDateSpecification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupdateSpecification
     * @return \StructType\InboundInternational
     */
    public function setPickupdateSpecification($pickupdateSpecification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistDateSpecification::valueIsValid($pickupdateSpecification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistDateSpecification', is_array($pickupdateSpecification) ? implode(', ', $pickupdateSpecification) : var_export($pickupdateSpecification, true), implode(', ', \EnumType\CodelistDateSpecification::getValidValues())), __LINE__);
        }
        $this->PickupdateSpecification = $pickupdateSpecification;
        return $this;
    }
    /**
     * Get Deliverydate value
     * @return string|null
     */
    public function getDeliverydate()
    {
        return $this->Deliverydate;
    }
    /**
     * Set Deliverydate value
     * @param string $deliverydate
     * @return \StructType\InboundInternational
     */
    public function setDeliverydate($deliverydate = null)
    {
        // validation for constraint: string
        if (!is_null($deliverydate) && !is_string($deliverydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverydate, true), gettype($deliverydate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($deliverydate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $deliverydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($deliverydate, true)), __LINE__);
        }
        $this->Deliverydate = $deliverydate;
        return $this;
    }
    /**
     * Get AdvicePhonenumber value
     * @return string|null
     */
    public function getAdvicePhonenumber()
    {
        return $this->AdvicePhonenumber;
    }
    /**
     * Set AdvicePhonenumber value
     * @param string $advicePhonenumber
     * @return \StructType\InboundInternational
     */
    public function setAdvicePhonenumber($advicePhonenumber = null)
    {
        // validation for constraint: string
        if (!is_null($advicePhonenumber) && !is_string($advicePhonenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advicePhonenumber, true), gettype($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($advicePhonenumber)), __LINE__);
        }
        $this->AdvicePhonenumber = $advicePhonenumber;
        return $this;
    }
    /**
     * Get GoodsValue value
     * @return float|null
     */
    public function getGoodsValue()
    {
        return $this->GoodsValue;
    }
    /**
     * Set GoodsValue value
     * @param float $goodsValue
     * @return \StructType\InboundInternational
     */
    public function setGoodsValue($goodsValue = null)
    {
        // validation for constraint: float
        if (!is_null($goodsValue) && !(is_float($goodsValue) || is_numeric($goodsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($goodsValue, true), gettype($goodsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($goodsValue) && mb_strlen(mb_substr($goodsValue, false !== mb_strpos($goodsValue, '.') ? mb_strpos($goodsValue, '.') + 1 : mb_strlen($goodsValue))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($goodsValue, true), mb_strlen(mb_substr($goodsValue, mb_strpos($goodsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999.99)
        if (!is_null($goodsValue) && $goodsValue > 9999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999.99', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($goodsValue) && $goodsValue < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,9}.[0-9]{2})
        if (!is_null($goodsValue) && !preg_match('/[1-9]{1}[0-9]{0,9}.[0-9]{2}/', $goodsValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,9}.[0-9]{2}', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($goodsValue) && mb_strlen(preg_replace('/(\D)/', '', $goodsValue)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($goodsValue, true), mb_strlen(preg_replace('/(\D)/', '', $goodsValue))), __LINE__);
        }
        $this->GoodsValue = $goodsValue;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @param string $contactPerson
     * @return \StructType\InboundInternational
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contactPerson)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactPerson)), __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get Pickuptext1 value
     * @return string|null
     */
    public function getPickuptext1()
    {
        return $this->Pickuptext1;
    }
    /**
     * Set Pickuptext1 value
     * @param string $pickuptext1
     * @return \StructType\InboundInternational
     */
    public function setPickuptext1($pickuptext1 = null)
    {
        // validation for constraint: string
        if (!is_null($pickuptext1) && !is_string($pickuptext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickuptext1, true), gettype($pickuptext1)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($pickuptext1) && mb_strlen($pickuptext1) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($pickuptext1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pickuptext1) && mb_strlen($pickuptext1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pickuptext1)), __LINE__);
        }
        $this->Pickuptext1 = $pickuptext1;
        return $this;
    }
    /**
     * Get Pickuptext2 value
     * @return string|null
     */
    public function getPickuptext2()
    {
        return $this->Pickuptext2;
    }
    /**
     * Set Pickuptext2 value
     * @param string $pickuptext2
     * @return \StructType\InboundInternational
     */
    public function setPickuptext2($pickuptext2 = null)
    {
        // validation for constraint: string
        if (!is_null($pickuptext2) && !is_string($pickuptext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickuptext2, true), gettype($pickuptext2)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($pickuptext2) && mb_strlen($pickuptext2) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($pickuptext2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pickuptext2) && mb_strlen($pickuptext2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pickuptext2)), __LINE__);
        }
        $this->Pickuptext2 = $pickuptext2;
        return $this;
    }
    /**
     * Get Pickuptext3 value
     * @return string|null
     */
    public function getPickuptext3()
    {
        return $this->Pickuptext3;
    }
    /**
     * Set Pickuptext3 value
     * @param string $pickuptext3
     * @return \StructType\InboundInternational
     */
    public function setPickuptext3($pickuptext3 = null)
    {
        // validation for constraint: string
        if (!is_null($pickuptext3) && !is_string($pickuptext3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickuptext3, true), gettype($pickuptext3)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($pickuptext3) && mb_strlen($pickuptext3) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($pickuptext3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pickuptext3) && mb_strlen($pickuptext3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pickuptext3)), __LINE__);
        }
        $this->Pickuptext3 = $pickuptext3;
        return $this;
    }
    /**
     * Get Ordertext1 value
     * @return string|null
     */
    public function getOrdertext1()
    {
        return $this->Ordertext1;
    }
    /**
     * Set Ordertext1 value
     * @param string $ordertext1
     * @return \StructType\InboundInternational
     */
    public function setOrdertext1($ordertext1 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext1) && !is_string($ordertext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext1, true), gettype($ordertext1)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext1)), __LINE__);
        }
        $this->Ordertext1 = $ordertext1;
        return $this;
    }
    /**
     * Get Ordertext2 value
     * @return string|null
     */
    public function getOrdertext2()
    {
        return $this->Ordertext2;
    }
    /**
     * Set Ordertext2 value
     * @param string $ordertext2
     * @return \StructType\InboundInternational
     */
    public function setOrdertext2($ordertext2 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext2) && !is_string($ordertext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext2, true), gettype($ordertext2)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext2)), __LINE__);
        }
        $this->Ordertext2 = $ordertext2;
        return $this;
    }
    /**
     * Get Invoicetext value
     * @return string|null
     */
    public function getInvoicetext()
    {
        return $this->Invoicetext;
    }
    /**
     * Set Invoicetext value
     * @param string $invoicetext
     * @return \StructType\InboundInternational
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($invoicetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoicetext)), __LINE__);
        }
        $this->Invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\InboundInternational
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: maxInclusive(99.999)
        if (!is_null($volume) && $volume > 99.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.999', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.000)
        if (!is_null($volume) && $volume < 0.000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{3})
        if (!is_null($volume) && !preg_match('/[0-9]{1,2}.[0-9]{3}/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{3}', var_export($volume, true)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get Loadingmeter value
     * @return float|null
     */
    public function getLoadingmeter()
    {
        return $this->Loadingmeter;
    }
    /**
     * Set Loadingmeter value
     * @param float $loadingmeter
     * @return \StructType\InboundInternational
     */
    public function setLoadingmeter($loadingmeter = null)
    {
        // validation for constraint: float
        if (!is_null($loadingmeter) && !(is_float($loadingmeter) || is_numeric($loadingmeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadingmeter, true), gettype($loadingmeter)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(mb_substr($loadingmeter, false !== mb_strpos($loadingmeter, '.') ? mb_strpos($loadingmeter, '.') + 1 : mb_strlen($loadingmeter))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($loadingmeter, true), mb_strlen(mb_substr($loadingmeter, mb_strpos($loadingmeter, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99.99)
        if (!is_null($loadingmeter) && $loadingmeter > 99.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.99', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($loadingmeter) && $loadingmeter < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{2})
        if (!is_null($loadingmeter) && !preg_match('/[0-9]{1,2}.[0-9]{2}/', $loadingmeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{2}', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(preg_replace('/(\D)/', '', $loadingmeter)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($loadingmeter, true), mb_strlen(preg_replace('/(\D)/', '', $loadingmeter))), __LINE__);
        }
        $this->Loadingmeter = $loadingmeter;
        return $this;
    }
}
