<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Product / Service | Produkt / Service
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The Loadinglist
     * Meta information extracted from the WSDL
     * - choice: Loadinglist | Barcode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Loadinglist
     */
    public $Loadinglist;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - choice: Loadinglist | Barcode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Barcode
     */
    public $Barcode;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setLoadinglist()
     * @uses DocumentType::setBarcode()
     * @param \StructType\Loadinglist $loadinglist
     * @param \StructType\Barcode $barcode
     */
    public function __construct(\StructType\Loadinglist $loadinglist = null, \StructType\Barcode $barcode = null)
    {
        $this
            ->setLoadinglist($loadinglist)
            ->setBarcode($barcode);
    }
    /**
     * Get Loadinglist value
     * @return \StructType\Loadinglist|null
     */
    public function getLoadinglist()
    {
        return isset($this->Loadinglist) ? $this->Loadinglist : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoadinglist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoadinglist method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoadinglistForChoiceConstraintsFromSetLoadinglist($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Barcode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Loadinglist can\'t be set as the property %s is already set. Only one property must be set among these properties: Loadinglist, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Loadinglist value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Loadinglist $loadinglist
     * @return \StructType\DocumentType
     */
    public function setLoadinglist(\StructType\Loadinglist $loadinglist = null)
    {
        // validation for constraint: choice(Loadinglist, Barcode)
        if ('' !== ($loadinglistChoiceErrorMessage = self::validateLoadinglistForChoiceConstraintsFromSetLoadinglist($loadinglist))) {
            throw new \InvalidArgumentException($loadinglistChoiceErrorMessage, __LINE__);
        }
        if (is_null($loadinglist) || (is_array($loadinglist) && empty($loadinglist))) {
            unset($this->Loadinglist);
        } else {
            $this->Loadinglist = $loadinglist;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * @return \StructType\Barcode|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBarcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBarcode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBarcodeForChoiceConstraintsFromSetBarcode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Loadinglist',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Barcode can\'t be set as the property %s is already set. Only one property must be set among these properties: Barcode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Barcode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Barcode $barcode
     * @return \StructType\DocumentType
     */
    public function setBarcode(\StructType\Barcode $barcode = null)
    {
        // validation for constraint: choice(Loadinglist, Barcode)
        if ('' !== ($barcodeChoiceErrorMessage = self::validateBarcodeForChoiceConstraintsFromSetBarcode($barcode))) {
            throw new \InvalidArgumentException($barcodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
}
