<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Routing ServiceType
 * @subpackage Services
 */
class Routing extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Routing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RoutingRequest $routingRequest
     * @return \StructType\RoutingResponse|bool
     */
    public function Routing(\StructType\RoutingRequest $routingRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->Routing($routingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RoutingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
