<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creation ServiceType
 * @subpackage Services
 */
class Creation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShipmentCreation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShipmentRequest $shipmentRequest
     * @return \StructType\ShipmentResponse|bool
     */
    public function ShipmentCreation(\StructType\ShipmentRequest $shipmentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ShipmentCreation($shipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ManifestCreation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ManifestRequest $manifestRequest
     * @return \StructType\ManifestResponse|bool
     */
    public function ManifestCreation(\StructType\ManifestRequest $manifestRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ManifestCreation($manifestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ManifestResponse|\StructType\ShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
