<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for boolean EnumType
 * @subpackage Enumerations
 */
class Boolean extends AbstractStructEnumBase
{
    /**
     * Constant for value 'true'
     * Meta information extracted from the WSDL
     * - documentation: wahr | true
     * @return string 'true'
     */
    const VALUE_TRUE = 'true';
    /**
     * Constant for value 'false'
     * Meta information extracted from the WSDL
     * - documentation: falsch | false
     * @return string 'false'
     */
    const VALUE_FALSE = 'false';
    /**
     * Return allowed values
     * @uses self::VALUE_TRUE
     * @uses self::VALUE_FALSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRUE,
            self::VALUE_FALSE,
        );
    }
}
