<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentService StructType
 * Meta information extracted from the WSDL
 * - documentation: Product / Service | Produkt / Service
 * @subpackage Structs
 */
class ShipmentService extends AbstractStructBase
{
    /**
     * The Standard
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Standard
     */
    public $Standard;
    /**
     * The Avis
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Avis
     */
    public $Avis;
    /**
     * The ExpressNextDay
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ExpressNextDay
     */
    public $ExpressNextDay;
    /**
     * The Express10
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Express10
     */
    public $Express10;
    /**
     * The Express12
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Express12
     */
    public $Express12;
    /**
     * The FixZustelldatum
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\FixZustelldatum
     */
    public $FixZustelldatum;
    /**
     * The Fix10
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Fix10
     */
    public $Fix10;
    /**
     * The Fix12
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Fix12
     */
    public $Fix12;
    /**
     * The Metro
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Metro
     */
    public $Metro;
    /**
     * The Rewe
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Rewe
     */
    public $Rewe;
    /**
     * The ToomRewe
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ToomRewe
     */
    public $ToomRewe;
    /**
     * The Pickup
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Pickup
     */
    public $Pickup;
    /**
     * The InboundNational
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\InboundNational
     */
    public $InboundNational;
    /**
     * The InboundInternational
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\InboundInternational
     */
    public $InboundInternational;
    /**
     * The Eurapid
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Eurapid
     */
    public $Eurapid;
    /**
     * The PrivateDomestic
     * Meta information extracted from the WSDL
     * - choice: Standard | Avis | ExpressNextDay | Express10 | Express12 | FixZustelldatum | Fix10 | Fix12 | Metro | Rewe | ToomRewe | Pickup | InboundNational | InboundInternational | Eurapid | PrivateDomestic
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PrivateDomestic
     */
    public $PrivateDomestic;
    /**
     * Constructor method for ShipmentService
     * @uses ShipmentService::setStandard()
     * @uses ShipmentService::setAvis()
     * @uses ShipmentService::setExpressNextDay()
     * @uses ShipmentService::setExpress10()
     * @uses ShipmentService::setExpress12()
     * @uses ShipmentService::setFixZustelldatum()
     * @uses ShipmentService::setFix10()
     * @uses ShipmentService::setFix12()
     * @uses ShipmentService::setMetro()
     * @uses ShipmentService::setRewe()
     * @uses ShipmentService::setToomRewe()
     * @uses ShipmentService::setPickup()
     * @uses ShipmentService::setInboundNational()
     * @uses ShipmentService::setInboundInternational()
     * @uses ShipmentService::setEurapid()
     * @uses ShipmentService::setPrivateDomestic()
     * @param \StructType\Standard $standard
     * @param \StructType\Avis $avis
     * @param \StructType\ExpressNextDay $expressNextDay
     * @param \StructType\Express10 $express10
     * @param \StructType\Express12 $express12
     * @param \StructType\FixZustelldatum $fixZustelldatum
     * @param \StructType\Fix10 $fix10
     * @param \StructType\Fix12 $fix12
     * @param \StructType\Metro $metro
     * @param \StructType\Rewe $rewe
     * @param \StructType\ToomRewe $toomRewe
     * @param \StructType\Pickup $pickup
     * @param \StructType\InboundNational $inboundNational
     * @param \StructType\InboundInternational $inboundInternational
     * @param \StructType\Eurapid $eurapid
     * @param \StructType\PrivateDomestic $privateDomestic
     */
    public function __construct(\StructType\Standard $standard = null, \StructType\Avis $avis = null, \StructType\ExpressNextDay $expressNextDay = null, \StructType\Express10 $express10 = null, \StructType\Express12 $express12 = null, \StructType\FixZustelldatum $fixZustelldatum = null, \StructType\Fix10 $fix10 = null, \StructType\Fix12 $fix12 = null, \StructType\Metro $metro = null, \StructType\Rewe $rewe = null, \StructType\ToomRewe $toomRewe = null, \StructType\Pickup $pickup = null, \StructType\InboundNational $inboundNational = null, \StructType\InboundInternational $inboundInternational = null, \StructType\Eurapid $eurapid = null, \StructType\PrivateDomestic $privateDomestic = null)
    {
        $this
            ->setStandard($standard)
            ->setAvis($avis)
            ->setExpressNextDay($expressNextDay)
            ->setExpress10($express10)
            ->setExpress12($express12)
            ->setFixZustelldatum($fixZustelldatum)
            ->setFix10($fix10)
            ->setFix12($fix12)
            ->setMetro($metro)
            ->setRewe($rewe)
            ->setToomRewe($toomRewe)
            ->setPickup($pickup)
            ->setInboundNational($inboundNational)
            ->setInboundInternational($inboundInternational)
            ->setEurapid($eurapid)
            ->setPrivateDomestic($privateDomestic);
    }
    /**
     * Get Standard value
     * @return \StructType\Standard|null
     */
    public function getStandard()
    {
        return isset($this->Standard) ? $this->Standard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStandard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStandardForChoiceConstraintsFromSetStandard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Standard can\'t be set as the property %s is already set. Only one property must be set among these properties: Standard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Standard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Standard $standard
     * @return \StructType\ShipmentService
     */
    public function setStandard(\StructType\Standard $standard = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($standardChoiceErrorMessage = self::validateStandardForChoiceConstraintsFromSetStandard($standard))) {
            throw new \InvalidArgumentException($standardChoiceErrorMessage, __LINE__);
        }
        if (is_null($standard) || (is_array($standard) && empty($standard))) {
            unset($this->Standard);
        } else {
            $this->Standard = $standard;
        }
        return $this;
    }
    /**
     * Get Avis value
     * @return \StructType\Avis|null
     */
    public function getAvis()
    {
        return isset($this->Avis) ? $this->Avis : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAvis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvis method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAvisForChoiceConstraintsFromSetAvis($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Avis can\'t be set as the property %s is already set. Only one property must be set among these properties: Avis, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Avis value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Avis $avis
     * @return \StructType\ShipmentService
     */
    public function setAvis(\StructType\Avis $avis = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($avisChoiceErrorMessage = self::validateAvisForChoiceConstraintsFromSetAvis($avis))) {
            throw new \InvalidArgumentException($avisChoiceErrorMessage, __LINE__);
        }
        if (is_null($avis) || (is_array($avis) && empty($avis))) {
            unset($this->Avis);
        } else {
            $this->Avis = $avis;
        }
        return $this;
    }
    /**
     * Get ExpressNextDay value
     * @return \StructType\ExpressNextDay|null
     */
    public function getExpressNextDay()
    {
        return isset($this->ExpressNextDay) ? $this->ExpressNextDay : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpressNextDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpressNextDay method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpressNextDayForChoiceConstraintsFromSetExpressNextDay($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ExpressNextDay can\'t be set as the property %s is already set. Only one property must be set among these properties: ExpressNextDay, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ExpressNextDay value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExpressNextDay $expressNextDay
     * @return \StructType\ShipmentService
     */
    public function setExpressNextDay(\StructType\ExpressNextDay $expressNextDay = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($expressNextDayChoiceErrorMessage = self::validateExpressNextDayForChoiceConstraintsFromSetExpressNextDay($expressNextDay))) {
            throw new \InvalidArgumentException($expressNextDayChoiceErrorMessage, __LINE__);
        }
        if (is_null($expressNextDay) || (is_array($expressNextDay) && empty($expressNextDay))) {
            unset($this->ExpressNextDay);
        } else {
            $this->ExpressNextDay = $expressNextDay;
        }
        return $this;
    }
    /**
     * Get Express10 value
     * @return \StructType\Express10|null
     */
    public function getExpress10()
    {
        return isset($this->Express10) ? $this->Express10 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpress10 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpress10 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpress10ForChoiceConstraintsFromSetExpress10($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Express10 can\'t be set as the property %s is already set. Only one property must be set among these properties: Express10, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Express10 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Express10 $express10
     * @return \StructType\ShipmentService
     */
    public function setExpress10(\StructType\Express10 $express10 = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($express10ChoiceErrorMessage = self::validateExpress10ForChoiceConstraintsFromSetExpress10($express10))) {
            throw new \InvalidArgumentException($express10ChoiceErrorMessage, __LINE__);
        }
        if (is_null($express10) || (is_array($express10) && empty($express10))) {
            unset($this->Express10);
        } else {
            $this->Express10 = $express10;
        }
        return $this;
    }
    /**
     * Get Express12 value
     * @return \StructType\Express12|null
     */
    public function getExpress12()
    {
        return isset($this->Express12) ? $this->Express12 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpress12 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpress12 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpress12ForChoiceConstraintsFromSetExpress12($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Express12 can\'t be set as the property %s is already set. Only one property must be set among these properties: Express12, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Express12 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Express12 $express12
     * @return \StructType\ShipmentService
     */
    public function setExpress12(\StructType\Express12 $express12 = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($express12ChoiceErrorMessage = self::validateExpress12ForChoiceConstraintsFromSetExpress12($express12))) {
            throw new \InvalidArgumentException($express12ChoiceErrorMessage, __LINE__);
        }
        if (is_null($express12) || (is_array($express12) && empty($express12))) {
            unset($this->Express12);
        } else {
            $this->Express12 = $express12;
        }
        return $this;
    }
    /**
     * Get FixZustelldatum value
     * @return \StructType\FixZustelldatum|null
     */
    public function getFixZustelldatum()
    {
        return isset($this->FixZustelldatum) ? $this->FixZustelldatum : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFixZustelldatum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFixZustelldatum method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFixZustelldatumForChoiceConstraintsFromSetFixZustelldatum($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FixZustelldatum can\'t be set as the property %s is already set. Only one property must be set among these properties: FixZustelldatum, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FixZustelldatum value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FixZustelldatum $fixZustelldatum
     * @return \StructType\ShipmentService
     */
    public function setFixZustelldatum(\StructType\FixZustelldatum $fixZustelldatum = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($fixZustelldatumChoiceErrorMessage = self::validateFixZustelldatumForChoiceConstraintsFromSetFixZustelldatum($fixZustelldatum))) {
            throw new \InvalidArgumentException($fixZustelldatumChoiceErrorMessage, __LINE__);
        }
        if (is_null($fixZustelldatum) || (is_array($fixZustelldatum) && empty($fixZustelldatum))) {
            unset($this->FixZustelldatum);
        } else {
            $this->FixZustelldatum = $fixZustelldatum;
        }
        return $this;
    }
    /**
     * Get Fix10 value
     * @return \StructType\Fix10|null
     */
    public function getFix10()
    {
        return isset($this->Fix10) ? $this->Fix10 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFix10 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFix10 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFix10ForChoiceConstraintsFromSetFix10($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Fix10 can\'t be set as the property %s is already set. Only one property must be set among these properties: Fix10, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Fix10 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Fix10 $fix10
     * @return \StructType\ShipmentService
     */
    public function setFix10(\StructType\Fix10 $fix10 = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($fix10ChoiceErrorMessage = self::validateFix10ForChoiceConstraintsFromSetFix10($fix10))) {
            throw new \InvalidArgumentException($fix10ChoiceErrorMessage, __LINE__);
        }
        if (is_null($fix10) || (is_array($fix10) && empty($fix10))) {
            unset($this->Fix10);
        } else {
            $this->Fix10 = $fix10;
        }
        return $this;
    }
    /**
     * Get Fix12 value
     * @return \StructType\Fix12|null
     */
    public function getFix12()
    {
        return isset($this->Fix12) ? $this->Fix12 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFix12 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFix12 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFix12ForChoiceConstraintsFromSetFix12($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Fix12 can\'t be set as the property %s is already set. Only one property must be set among these properties: Fix12, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Fix12 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Fix12 $fix12
     * @return \StructType\ShipmentService
     */
    public function setFix12(\StructType\Fix12 $fix12 = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($fix12ChoiceErrorMessage = self::validateFix12ForChoiceConstraintsFromSetFix12($fix12))) {
            throw new \InvalidArgumentException($fix12ChoiceErrorMessage, __LINE__);
        }
        if (is_null($fix12) || (is_array($fix12) && empty($fix12))) {
            unset($this->Fix12);
        } else {
            $this->Fix12 = $fix12;
        }
        return $this;
    }
    /**
     * Get Metro value
     * @return \StructType\Metro|null
     */
    public function getMetro()
    {
        return isset($this->Metro) ? $this->Metro : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMetro method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMetro method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMetroForChoiceConstraintsFromSetMetro($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Metro can\'t be set as the property %s is already set. Only one property must be set among these properties: Metro, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Metro value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Metro $metro
     * @return \StructType\ShipmentService
     */
    public function setMetro(\StructType\Metro $metro = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($metroChoiceErrorMessage = self::validateMetroForChoiceConstraintsFromSetMetro($metro))) {
            throw new \InvalidArgumentException($metroChoiceErrorMessage, __LINE__);
        }
        if (is_null($metro) || (is_array($metro) && empty($metro))) {
            unset($this->Metro);
        } else {
            $this->Metro = $metro;
        }
        return $this;
    }
    /**
     * Get Rewe value
     * @return \StructType\Rewe|null
     */
    public function getRewe()
    {
        return isset($this->Rewe) ? $this->Rewe : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRewe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRewe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReweForChoiceConstraintsFromSetRewe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Rewe can\'t be set as the property %s is already set. Only one property must be set among these properties: Rewe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Rewe value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rewe $rewe
     * @return \StructType\ShipmentService
     */
    public function setRewe(\StructType\Rewe $rewe = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($reweChoiceErrorMessage = self::validateReweForChoiceConstraintsFromSetRewe($rewe))) {
            throw new \InvalidArgumentException($reweChoiceErrorMessage, __LINE__);
        }
        if (is_null($rewe) || (is_array($rewe) && empty($rewe))) {
            unset($this->Rewe);
        } else {
            $this->Rewe = $rewe;
        }
        return $this;
    }
    /**
     * Get ToomRewe value
     * @return \StructType\ToomRewe|null
     */
    public function getToomRewe()
    {
        return isset($this->ToomRewe) ? $this->ToomRewe : null;
    }
    /**
     * This method is responsible for validating the value passed to the setToomRewe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToomRewe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateToomReweForChoiceConstraintsFromSetToomRewe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ToomRewe can\'t be set as the property %s is already set. Only one property must be set among these properties: ToomRewe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ToomRewe value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ToomRewe $toomRewe
     * @return \StructType\ShipmentService
     */
    public function setToomRewe(\StructType\ToomRewe $toomRewe = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($toomReweChoiceErrorMessage = self::validateToomReweForChoiceConstraintsFromSetToomRewe($toomRewe))) {
            throw new \InvalidArgumentException($toomReweChoiceErrorMessage, __LINE__);
        }
        if (is_null($toomRewe) || (is_array($toomRewe) && empty($toomRewe))) {
            unset($this->ToomRewe);
        } else {
            $this->ToomRewe = $toomRewe;
        }
        return $this;
    }
    /**
     * Get Pickup value
     * @return \StructType\Pickup|null
     */
    public function getPickup()
    {
        return isset($this->Pickup) ? $this->Pickup : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPickup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickup method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePickupForChoiceConstraintsFromSetPickup($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Pickup can\'t be set as the property %s is already set. Only one property must be set among these properties: Pickup, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Pickup value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pickup $pickup
     * @return \StructType\ShipmentService
     */
    public function setPickup(\StructType\Pickup $pickup = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($pickupChoiceErrorMessage = self::validatePickupForChoiceConstraintsFromSetPickup($pickup))) {
            throw new \InvalidArgumentException($pickupChoiceErrorMessage, __LINE__);
        }
        if (is_null($pickup) || (is_array($pickup) && empty($pickup))) {
            unset($this->Pickup);
        } else {
            $this->Pickup = $pickup;
        }
        return $this;
    }
    /**
     * Get InboundNational value
     * @return \StructType\InboundNational|null
     */
    public function getInboundNational()
    {
        return isset($this->InboundNational) ? $this->InboundNational : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInboundNational method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInboundNational method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInboundNationalForChoiceConstraintsFromSetInboundNational($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundInternational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InboundNational can\'t be set as the property %s is already set. Only one property must be set among these properties: InboundNational, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InboundNational value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InboundNational $inboundNational
     * @return \StructType\ShipmentService
     */
    public function setInboundNational(\StructType\InboundNational $inboundNational = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($inboundNationalChoiceErrorMessage = self::validateInboundNationalForChoiceConstraintsFromSetInboundNational($inboundNational))) {
            throw new \InvalidArgumentException($inboundNationalChoiceErrorMessage, __LINE__);
        }
        if (is_null($inboundNational) || (is_array($inboundNational) && empty($inboundNational))) {
            unset($this->InboundNational);
        } else {
            $this->InboundNational = $inboundNational;
        }
        return $this;
    }
    /**
     * Get InboundInternational value
     * @return \StructType\InboundInternational|null
     */
    public function getInboundInternational()
    {
        return isset($this->InboundInternational) ? $this->InboundInternational : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInboundInternational method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInboundInternational method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInboundInternationalForChoiceConstraintsFromSetInboundInternational($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'Eurapid',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InboundInternational can\'t be set as the property %s is already set. Only one property must be set among these properties: InboundInternational, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InboundInternational value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InboundInternational $inboundInternational
     * @return \StructType\ShipmentService
     */
    public function setInboundInternational(\StructType\InboundInternational $inboundInternational = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($inboundInternationalChoiceErrorMessage = self::validateInboundInternationalForChoiceConstraintsFromSetInboundInternational($inboundInternational))) {
            throw new \InvalidArgumentException($inboundInternationalChoiceErrorMessage, __LINE__);
        }
        if (is_null($inboundInternational) || (is_array($inboundInternational) && empty($inboundInternational))) {
            unset($this->InboundInternational);
        } else {
            $this->InboundInternational = $inboundInternational;
        }
        return $this;
    }
    /**
     * Get Eurapid value
     * @return \StructType\Eurapid|null
     */
    public function getEurapid()
    {
        return isset($this->Eurapid) ? $this->Eurapid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEurapid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEurapid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEurapidForChoiceConstraintsFromSetEurapid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'PrivateDomestic',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Eurapid can\'t be set as the property %s is already set. Only one property must be set among these properties: Eurapid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Eurapid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Eurapid $eurapid
     * @return \StructType\ShipmentService
     */
    public function setEurapid(\StructType\Eurapid $eurapid = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($eurapidChoiceErrorMessage = self::validateEurapidForChoiceConstraintsFromSetEurapid($eurapid))) {
            throw new \InvalidArgumentException($eurapidChoiceErrorMessage, __LINE__);
        }
        if (is_null($eurapid) || (is_array($eurapid) && empty($eurapid))) {
            unset($this->Eurapid);
        } else {
            $this->Eurapid = $eurapid;
        }
        return $this;
    }
    /**
     * Get PrivateDomestic value
     * @return \StructType\PrivateDomestic|null
     */
    public function getPrivateDomestic()
    {
        return isset($this->PrivateDomestic) ? $this->PrivateDomestic : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrivateDomestic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrivateDomestic method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrivateDomesticForChoiceConstraintsFromSetPrivateDomestic($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Standard',
            'Avis',
            'ExpressNextDay',
            'Express10',
            'Express12',
            'FixZustelldatum',
            'Fix10',
            'Fix12',
            'Metro',
            'Rewe',
            'ToomRewe',
            'Pickup',
            'InboundNational',
            'InboundInternational',
            'Eurapid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PrivateDomestic can\'t be set as the property %s is already set. Only one property must be set among these properties: PrivateDomestic, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PrivateDomestic value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PrivateDomestic $privateDomestic
     * @return \StructType\ShipmentService
     */
    public function setPrivateDomestic(\StructType\PrivateDomestic $privateDomestic = null)
    {
        // validation for constraint: choice(Standard, Avis, ExpressNextDay, Express10, Express12, FixZustelldatum, Fix10, Fix12, Metro, Rewe, ToomRewe, Pickup, InboundNational, InboundInternational, Eurapid, PrivateDomestic)
        if ('' !== ($privateDomesticChoiceErrorMessage = self::validatePrivateDomesticForChoiceConstraintsFromSetPrivateDomestic($privateDomestic))) {
            throw new \InvalidArgumentException($privateDomesticChoiceErrorMessage, __LINE__);
        }
        if (is_null($privateDomestic) || (is_array($privateDomestic) && empty($privateDomestic))) {
            unset($this->PrivateDomestic);
        } else {
            $this->PrivateDomestic = $privateDomestic;
        }
        return $this;
    }
}
