<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The ShipmentDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ShipmentDetails
     */
    public $ShipmentDetails;
    /**
     * The AX4ShipmentNo
     * Meta information extracted from the WSDL
     * - documentation: AX4 Shipment no. | AX4 Sendungsnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AX4ShipmentNo;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Error[]
     */
    public $Error;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - documentation: Validation result | Validierungsstatus
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Result;
    /**
     * The Consignor
     * Meta information extracted from the WSDL
     * - documentation: Consignor | Versender
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressConsignor
     */
    public $Consignor;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Product / Service | Produkt / Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoutingService
     */
    public $Service;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment reference | Sendungsreferenz
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Deliverydate
     * Meta information extracted from the WSDL
     * - documentation: Deliverydate | Zustelldatum
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliverydate;
    /**
     * The Shuttle
     * Meta information extracted from the WSDL
     * - documentation: Shuttle
     * - base: xsd:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shuttle;
    /**
     * The RoutingAreaTo
     * Meta information extracted from the WSDL
     * - documentation: Routing Area To
     * - base: xsd:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingAreaTo;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - documentation: Terminal
     * - base: xsd:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Terminal;
    /**
     * The Tour
     * Meta information extracted from the WSDL
     * - documentation: Tour
     * - base: xsd:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tour;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - documentation: Product Code
     * - base: xsd:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The Positions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Positions
     */
    public $Positions;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - documentation: Remarks | Hinweis
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The AX4ShipmentValidation
     * Meta information extracted from the WSDL
     * - choice: AX4ShipmentValidation | General | AX4ShipmentValidation | General
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\AX4ShipmentValidation
     */
    public $AX4ShipmentValidation;
    /**
     * The General
     * Meta information extracted from the WSDL
     * - choice: AX4ShipmentValidation | General | AX4ShipmentValidation | General
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\General
     */
    public $General;
    /**
     * The Barcodes
     * Meta information extracted from the WSDL
     * - documentation: Barcodes
     * - base: xsd:base64Binary
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcodes;
    /**
     * The Errormessage
     * Meta information extracted from the WSDL
     * - documentation: Errormessage | Fehlerbeschreibung
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Errormessage;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setShipmentDetails()
     * @uses Shipment::setAX4ShipmentNo()
     * @uses Shipment::setError()
     * @uses Shipment::setResult()
     * @uses Shipment::setConsignor()
     * @uses Shipment::setService()
     * @uses Shipment::setReference()
     * @uses Shipment::setDeliverydate()
     * @uses Shipment::setShuttle()
     * @uses Shipment::setRoutingAreaTo()
     * @uses Shipment::setTerminal()
     * @uses Shipment::setTour()
     * @uses Shipment::setProductCode()
     * @uses Shipment::setPositions()
     * @uses Shipment::setRemarks()
     * @uses Shipment::setAX4ShipmentValidation()
     * @uses Shipment::setGeneral()
     * @uses Shipment::setBarcodes()
     * @uses Shipment::setErrormessage()
     * @param \StructType\ShipmentDetails $shipmentDetails
     * @param string $aX4ShipmentNo
     * @param \StructType\Error[] $error
     * @param string $result
     * @param \StructType\AddressConsignor $consignor
     * @param \StructType\RoutingService $service
     * @param string $reference
     * @param string $deliverydate
     * @param string $shuttle
     * @param string $routingAreaTo
     * @param string $terminal
     * @param string $tour
     * @param string $productCode
     * @param \StructType\Positions $positions
     * @param string $remarks
     * @param \StructType\AX4ShipmentValidation $aX4ShipmentValidation
     * @param \StructType\General $general
     * @param string $barcodes
     * @param string $errormessage
     */
    public function __construct(\StructType\ShipmentDetails $shipmentDetails = null, $aX4ShipmentNo = null, array $error = array(), $result = null, \StructType\AddressConsignor $consignor = null, \StructType\RoutingService $service = null, $reference = null, $deliverydate = null, $shuttle = null, $routingAreaTo = null, $terminal = null, $tour = null, $productCode = null, \StructType\Positions $positions = null, $remarks = null, \StructType\AX4ShipmentValidation $aX4ShipmentValidation = null, \StructType\General $general = null, $barcodes = null, $errormessage = null)
    {
        $this
            ->setShipmentDetails($shipmentDetails)
            ->setAX4ShipmentNo($aX4ShipmentNo)
            ->setError($error)
            ->setResult($result)
            ->setConsignor($consignor)
            ->setService($service)
            ->setReference($reference)
            ->setDeliverydate($deliverydate)
            ->setShuttle($shuttle)
            ->setRoutingAreaTo($routingAreaTo)
            ->setTerminal($terminal)
            ->setTour($tour)
            ->setProductCode($productCode)
            ->setPositions($positions)
            ->setRemarks($remarks)
            ->setAX4ShipmentValidation($aX4ShipmentValidation)
            ->setGeneral($general)
            ->setBarcodes($barcodes)
            ->setErrormessage($errormessage);
    }
    /**
     * Get ShipmentDetails value
     * @return \StructType\ShipmentDetails
     */
    public function getShipmentDetails()
    {
        return $this->ShipmentDetails;
    }
    /**
     * Set ShipmentDetails value
     * @param \StructType\ShipmentDetails $shipmentDetails
     * @return \StructType\Shipment
     */
    public function setShipmentDetails(\StructType\ShipmentDetails $shipmentDetails = null)
    {
        $this->ShipmentDetails = $shipmentDetails;
        return $this;
    }
    /**
     * Get AX4ShipmentNo value
     * @return string
     */
    public function getAX4ShipmentNo()
    {
        return $this->AX4ShipmentNo;
    }
    /**
     * Set AX4ShipmentNo value
     * @param string $aX4ShipmentNo
     * @return \StructType\Shipment
     */
    public function setAX4ShipmentNo($aX4ShipmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($aX4ShipmentNo) && !is_string($aX4ShipmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aX4ShipmentNo, true), gettype($aX4ShipmentNo)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aX4ShipmentNo) && mb_strlen($aX4ShipmentNo) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aX4ShipmentNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aX4ShipmentNo) && mb_strlen($aX4ShipmentNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aX4ShipmentNo)), __LINE__);
        }
        $this->AX4ShipmentNo = $aX4ShipmentNo;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\Error[]
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentErrorItem) {
            // validation for constraint: itemType
            if (!$shipmentErrorItem instanceof \StructType\Error) {
                $invalidValues[] = is_object($shipmentErrorItem) ? get_class($shipmentErrorItem) : sprintf('%s(%s)', gettype($shipmentErrorItem), var_export($shipmentErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error[] $error
     * @return \StructType\Shipment
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error $item
     * @return \StructType\Shipment
     */
    public function addToError(\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of type \StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get Result value
     * @return string
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\Shipment
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($result) && mb_strlen($result) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($result)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($result) && mb_strlen($result) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Consignor value
     * @return \StructType\AddressConsignor
     */
    public function getConsignor()
    {
        return $this->Consignor;
    }
    /**
     * Set Consignor value
     * @param \StructType\AddressConsignor $consignor
     * @return \StructType\Shipment
     */
    public function setConsignor(\StructType\AddressConsignor $consignor = null)
    {
        $this->Consignor = $consignor;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\RoutingService
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\RoutingService $service
     * @return \StructType\Shipment
     */
    public function setService(\StructType\RoutingService $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\Shipment
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($reference) && mb_strlen($reference) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reference) && mb_strlen($reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Deliverydate value
     * @return string|null
     */
    public function getDeliverydate()
    {
        return $this->Deliverydate;
    }
    /**
     * Set Deliverydate value
     * @param string $deliverydate
     * @return \StructType\Shipment
     */
    public function setDeliverydate($deliverydate = null)
    {
        // validation for constraint: string
        if (!is_null($deliverydate) && !is_string($deliverydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverydate, true), gettype($deliverydate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($deliverydate) && mb_strlen($deliverydate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($deliverydate)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($deliverydate) && mb_strlen($deliverydate) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($deliverydate)), __LINE__);
        }
        $this->Deliverydate = $deliverydate;
        return $this;
    }
    /**
     * Get Shuttle value
     * @return string|null
     */
    public function getShuttle()
    {
        return $this->Shuttle;
    }
    /**
     * Set Shuttle value
     * @param string $shuttle
     * @return \StructType\Shipment
     */
    public function setShuttle($shuttle = null)
    {
        // validation for constraint: string
        if (!is_null($shuttle) && !is_string($shuttle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shuttle, true), gettype($shuttle)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($shuttle) && mb_strlen($shuttle) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($shuttle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shuttle) && mb_strlen($shuttle) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shuttle)), __LINE__);
        }
        $this->Shuttle = $shuttle;
        return $this;
    }
    /**
     * Get RoutingAreaTo value
     * @return string|null
     */
    public function getRoutingAreaTo()
    {
        return $this->RoutingAreaTo;
    }
    /**
     * Set RoutingAreaTo value
     * @param string $routingAreaTo
     * @return \StructType\Shipment
     */
    public function setRoutingAreaTo($routingAreaTo = null)
    {
        // validation for constraint: string
        if (!is_null($routingAreaTo) && !is_string($routingAreaTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingAreaTo, true), gettype($routingAreaTo)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($routingAreaTo) && mb_strlen($routingAreaTo) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($routingAreaTo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($routingAreaTo) && mb_strlen($routingAreaTo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($routingAreaTo)), __LINE__);
        }
        $this->RoutingAreaTo = $routingAreaTo;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\Shipment
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($terminal) && mb_strlen($terminal) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($terminal)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($terminal) && mb_strlen($terminal) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get Tour value
     * @return string|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param string $tour
     * @return \StructType\Shipment
     */
    public function setTour($tour = null)
    {
        // validation for constraint: string
        if (!is_null($tour) && !is_string($tour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tour, true), gettype($tour)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($tour) && mb_strlen($tour) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($tour)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($tour) && mb_strlen($tour) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($tour)), __LINE__);
        }
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\Shipment
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($productCode) && mb_strlen($productCode) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($productCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productCode) && mb_strlen($productCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get Positions value
     * @return \StructType\Positions|null
     */
    public function getPositions()
    {
        return $this->Positions;
    }
    /**
     * Set Positions value
     * @param \StructType\Positions $positions
     * @return \StructType\Shipment
     */
    public function setPositions(\StructType\Positions $positions = null)
    {
        $this->Positions = $positions;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \StructType\Shipment
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($remarks) && mb_strlen($remarks) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($remarks)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remarks) && mb_strlen($remarks) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get AX4ShipmentValidation value
     * @return \StructType\AX4ShipmentValidation|null
     */
    public function getAX4ShipmentValidation()
    {
        return isset($this->AX4ShipmentValidation) ? $this->AX4ShipmentValidation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAX4ShipmentValidation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAX4ShipmentValidation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAX4ShipmentValidationForChoiceConstraintsFromSetAX4ShipmentValidation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'General',
            'General',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AX4ShipmentValidation can\'t be set as the property %s is already set. Only one property must be set among these properties: AX4ShipmentValidation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AX4ShipmentValidation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AX4ShipmentValidation $aX4ShipmentValidation
     * @return \StructType\Shipment
     */
    public function setAX4ShipmentValidation(\StructType\AX4ShipmentValidation $aX4ShipmentValidation = null)
    {
        // validation for constraint: choice(AX4ShipmentValidation, General, AX4ShipmentValidation, General)
        if ('' !== ($aX4ShipmentValidationChoiceErrorMessage = self::validateAX4ShipmentValidationForChoiceConstraintsFromSetAX4ShipmentValidation($aX4ShipmentValidation))) {
            throw new \InvalidArgumentException($aX4ShipmentValidationChoiceErrorMessage, __LINE__);
        }
        if (is_null($aX4ShipmentValidation) || (is_array($aX4ShipmentValidation) && empty($aX4ShipmentValidation))) {
            unset($this->AX4ShipmentValidation);
        } else {
            $this->AX4ShipmentValidation = $aX4ShipmentValidation;
        }
        return $this;
    }
    /**
     * Get General value
     * @return \StructType\General|null
     */
    public function getGeneral()
    {
        return isset($this->General) ? $this->General : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneral method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneral method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneralForChoiceConstraintsFromSetGeneral($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AX4ShipmentValidation',
            'AX4ShipmentValidation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property General can\'t be set as the property %s is already set. Only one property must be set among these properties: General, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set General value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\General $general
     * @return \StructType\Shipment
     */
    public function setGeneral(\StructType\General $general = null)
    {
        // validation for constraint: choice(AX4ShipmentValidation, General, AX4ShipmentValidation, General)
        if ('' !== ($generalChoiceErrorMessage = self::validateGeneralForChoiceConstraintsFromSetGeneral($general))) {
            throw new \InvalidArgumentException($generalChoiceErrorMessage, __LINE__);
        }
        if (is_null($general) || (is_array($general) && empty($general))) {
            unset($this->General);
        } else {
            $this->General = $general;
        }
        return $this;
    }
    /**
     * Get Barcodes value
     * @return string|null
     */
    public function getBarcodes()
    {
        return $this->Barcodes;
    }
    /**
     * Set Barcodes value
     * @param string $barcodes
     * @return \StructType\Shipment
     */
    public function setBarcodes($barcodes = null)
    {
        // validation for constraint: string
        if (!is_null($barcodes) && !is_string($barcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodes, true), gettype($barcodes)), __LINE__);
        }
        $this->Barcodes = $barcodes;
        return $this;
    }
    /**
     * Get Errormessage value
     * @return string|null
     */
    public function getErrormessage()
    {
        return $this->Errormessage;
    }
    /**
     * Set Errormessage value
     * @param string $errormessage
     * @return \StructType\Shipment
     */
    public function setErrormessage($errormessage = null)
    {
        // validation for constraint: string
        if (!is_null($errormessage) && !is_string($errormessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errormessage, true), gettype($errormessage)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($errormessage) && mb_strlen($errormessage) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($errormessage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($errormessage) && mb_strlen($errormessage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($errormessage)), __LINE__);
        }
        $this->Errormessage = $errormessage;
        return $this;
    }
}
