<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivateDomestic StructType
 * Meta information extracted from the WSDL
 * - documentation: B2C Private Consignee (only Germany) | B2C Privatempfänger (nur Deutschland)
 * @subpackage Structs
 */
class PrivateDomestic extends AbstractStructBase
{
    /**
     * The B2CDeliveryServices
     * Meta information extracted from the WSDL
     * - documentation: B2C Delivery Services | Privatkunden-Zustell-Services
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $B2CDeliveryServices;
    /**
     * The Deliverydate
     * Meta information extracted from the WSDL
     * - documentation: Deliverydate | Zustelldatum | Deliverydate (not to be used with service PAV) | Zustelldatum (nicht für Service PAV)
     * - base: xsd:dateTime
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))
     * @var string
     */
    public $Deliverydate;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - documentation: Terms of delivery | Frankatur
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryTerms;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment reference | Sendungsreferenz
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Reference;
    /**
     * The AdvicePhonenumber
     * Meta information extracted from the WSDL
     * - documentation: Adive phone number | Avis Telefonnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdvicePhonenumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * The ConsigneeReference
     * Meta information extracted from the WSDL
     * - documentation: Consignee Reference | Empfänger Referenz
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeReference;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Consignee contact person | Ansprechpartner Empfänger
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPerson;
    /**
     * The Ordertext1
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 1 | Auftragstext 1
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext1;
    /**
     * The Ordertext2
     * Meta information extracted from the WSDL
     * - documentation: Ordertext 2 | Auftragstext 2
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordertext2;
    /**
     * The Invoicetext
     * Meta information extracted from the WSDL
     * - documentation: Invoicetext | Fakturiertext
     * - base: xsd:string
     * - maxLength: 33
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoicetext;
    /**
     * The ProductReferenceCode
     * Meta information extracted from the WSDL
     * - documentation: Product reference code | Produkt Referenz Code
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductReferenceCode;
    /**
     * The GoodsValue
     * Meta information extracted from the WSDL
     * - documentation: Goods value (in euro) | Warenwert (in Euro)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,9}.[0-9]{2}
     * - totalDigits: 12
     * @var float
     */
    public $GoodsValue;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - documentation: Volume (in m3) | Volumen (in m3)
     * - base: xsd:decimal
     * - maxInclusive: 99.999
     * - maxOccurs: 1
     * - minInclusive: 0.000
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{3}
     * @var float
     */
    public $Volume;
    /**
     * The Loadingmeter
     * Meta information extracted from the WSDL
     * - documentation: Loadingmeter | Lademeter
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 99.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [0-9]{1,2}.[0-9]{2}
     * - totalDigits: 2
     * @var float
     */
    public $Loadingmeter;
    /**
     * The LoadingunitsFP
     * Meta information extracted from the WSDL
     * - documentation: Amount of loadingunits FP | Anzahl Ladehilfsmittel FP
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadingunitsFP;
    /**
     * The LoadingunitsGP
     * Meta information extracted from the WSDL
     * - documentation: Amount of loadingunits GP | Anzahl Ladehilfsmittel GP
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadingunitsGP;
    /**
     * The Shipping
     * Meta information extracted from the WSDL
     * - documentation: Shipping Dropdown | Versandweg Auswahlliste
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping;
    /**
     * The ShippingFreetext
     * Meta information extracted from the WSDL
     * - documentation: Shipping freetext | Versandweg Freitext
     * - base: xsd:string
     * - maxLength: 45
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingFreetext;
    /**
     * The DriverAdvice
     * Meta information extracted from the WSDL
     * - documentation: Driver Advice (Driver advice is an additional service which is for a fee and must be agreed with your DHL contact person.) | Fahreravis (Die Zusatzleistung Fahreravis ist eine kostenpflichtige Mehrwertleistung, die vorab mit Ihrem
     * Ansprechpartner vereinbart sein muss.)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAdvice;
    /**
     * The DriverAdviceText
     * Meta information extracted from the WSDL
     * - documentation: Driver Advice Phonenumber | Fahreravis Telefonnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAdviceText;
    /**
     * The DeliveryFreeAtPlaceOfUse
     * Meta information extracted from the WSDL
     * - documentation: Delivery free at place of use (Delivery free at place of use is an additional service which is for a fee and must be agreed with your DHL contact person.) | Abtrageleistung (Die Zusatzleistung Abtrageleistung ist eine kostenpfltige
     * Mehrwertleistung, die vorab mit Ihrem Ansprechpartner vereinbart sein muss.)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryFreeAtPlaceOfUse;
    /**
     * The CashOnDelivery
     * Meta information extracted from the WSDL
     * - documentation: Cash on delivery in € | Nachname in €
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999999.99
     * - maxOccurs: 1
     * - minInclusive: 0.00
     * - minOccurs: 0
     * - pattern: [1-9]{1}[0-9]{0,9}.[0-9]{2}
     * - totalDigits: 12
     * @var float
     */
    public $CashOnDelivery;
    /**
     * The TermsOfPayment
     * Meta information extracted from the WSDL
     * - documentation: Terms of payment | Zahlungsart
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsOfPayment;
    /**
     * Constructor method for PrivateDomestic
     * @uses PrivateDomestic::setB2CDeliveryServices()
     * @uses PrivateDomestic::setDeliverydate()
     * @uses PrivateDomestic::setDeliveryTerms()
     * @uses PrivateDomestic::setReference()
     * @uses PrivateDomestic::setAdvicePhonenumber()
     * @uses PrivateDomestic::setAddress()
     * @uses PrivateDomestic::setPosition()
     * @uses PrivateDomestic::setConsigneeReference()
     * @uses PrivateDomestic::setContactPerson()
     * @uses PrivateDomestic::setOrdertext1()
     * @uses PrivateDomestic::setOrdertext2()
     * @uses PrivateDomestic::setInvoicetext()
     * @uses PrivateDomestic::setProductReferenceCode()
     * @uses PrivateDomestic::setGoodsValue()
     * @uses PrivateDomestic::setVolume()
     * @uses PrivateDomestic::setLoadingmeter()
     * @uses PrivateDomestic::setLoadingunitsFP()
     * @uses PrivateDomestic::setLoadingunitsGP()
     * @uses PrivateDomestic::setShipping()
     * @uses PrivateDomestic::setShippingFreetext()
     * @uses PrivateDomestic::setDriverAdvice()
     * @uses PrivateDomestic::setDriverAdviceText()
     * @uses PrivateDomestic::setDeliveryFreeAtPlaceOfUse()
     * @uses PrivateDomestic::setCashOnDelivery()
     * @uses PrivateDomestic::setTermsOfPayment()
     * @param string $b2CDeliveryServices
     * @param string $deliverydate
     * @param string $deliveryTerms
     * @param string $reference
     * @param string $advicePhonenumber
     * @param \StructType\Address $address
     * @param \StructType\Position[] $position
     * @param string $consigneeReference
     * @param string $contactPerson
     * @param string $ordertext1
     * @param string $ordertext2
     * @param string $invoicetext
     * @param string $productReferenceCode
     * @param float $goodsValue
     * @param float $volume
     * @param float $loadingmeter
     * @param string $loadingunitsFP
     * @param string $loadingunitsGP
     * @param string $shipping
     * @param string $shippingFreetext
     * @param string $driverAdvice
     * @param string $driverAdviceText
     * @param string $deliveryFreeAtPlaceOfUse
     * @param float $cashOnDelivery
     * @param string $termsOfPayment
     */
    public function __construct($b2CDeliveryServices = null, $deliverydate = null, $deliveryTerms = null, $reference = null, $advicePhonenumber = null, \StructType\Address $address = null, array $position = array(), $consigneeReference = null, $contactPerson = null, $ordertext1 = null, $ordertext2 = null, $invoicetext = null, $productReferenceCode = null, $goodsValue = null, $volume = null, $loadingmeter = null, $loadingunitsFP = null, $loadingunitsGP = null, $shipping = null, $shippingFreetext = null, $driverAdvice = null, $driverAdviceText = null, $deliveryFreeAtPlaceOfUse = null, $cashOnDelivery = null, $termsOfPayment = null)
    {
        $this
            ->setB2CDeliveryServices($b2CDeliveryServices)
            ->setDeliverydate($deliverydate)
            ->setDeliveryTerms($deliveryTerms)
            ->setReference($reference)
            ->setAdvicePhonenumber($advicePhonenumber)
            ->setAddress($address)
            ->setPosition($position)
            ->setConsigneeReference($consigneeReference)
            ->setContactPerson($contactPerson)
            ->setOrdertext1($ordertext1)
            ->setOrdertext2($ordertext2)
            ->setInvoicetext($invoicetext)
            ->setProductReferenceCode($productReferenceCode)
            ->setGoodsValue($goodsValue)
            ->setVolume($volume)
            ->setLoadingmeter($loadingmeter)
            ->setLoadingunitsFP($loadingunitsFP)
            ->setLoadingunitsGP($loadingunitsGP)
            ->setShipping($shipping)
            ->setShippingFreetext($shippingFreetext)
            ->setDriverAdvice($driverAdvice)
            ->setDriverAdviceText($driverAdviceText)
            ->setDeliveryFreeAtPlaceOfUse($deliveryFreeAtPlaceOfUse)
            ->setCashOnDelivery($cashOnDelivery)
            ->setTermsOfPayment($termsOfPayment);
    }
    /**
     * Get B2CDeliveryServices value
     * @return string
     */
    public function getB2CDeliveryServices()
    {
        return $this->B2CDeliveryServices;
    }
    /**
     * Set B2CDeliveryServices value
     * @uses \EnumType\CodelistB2CDeliveryServices::valueIsValid()
     * @uses \EnumType\CodelistB2CDeliveryServices::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $b2CDeliveryServices
     * @return \StructType\PrivateDomestic
     */
    public function setB2CDeliveryServices($b2CDeliveryServices = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistB2CDeliveryServices::valueIsValid($b2CDeliveryServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistB2CDeliveryServices', is_array($b2CDeliveryServices) ? implode(', ', $b2CDeliveryServices) : var_export($b2CDeliveryServices, true), implode(', ', \EnumType\CodelistB2CDeliveryServices::getValidValues())), __LINE__);
        }
        $this->B2CDeliveryServices = $b2CDeliveryServices;
        return $this;
    }
    /**
     * Get Deliverydate value
     * @return string
     */
    public function getDeliverydate()
    {
        return $this->Deliverydate;
    }
    /**
     * Set Deliverydate value
     * @param string $deliverydate
     * @return \StructType\PrivateDomestic
     */
    public function setDeliverydate($deliverydate = null)
    {
        // validation for constraint: string
        if (!is_null($deliverydate) && !is_string($deliverydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverydate, true), gettype($deliverydate)), __LINE__);
        }
        // validation for constraint: pattern(((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01])))
        if (!is_null($deliverydate) && !preg_match('/((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))/', $deliverydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))', var_export($deliverydate, true)), __LINE__);
        }
        $this->Deliverydate = $deliverydate;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return string
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * Set DeliveryTerms value
     * @uses \EnumType\CodelistDeliveryterms::valueIsValid()
     * @uses \EnumType\CodelistDeliveryterms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryTerms
     * @return \StructType\PrivateDomestic
     */
    public function setDeliveryTerms($deliveryTerms = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistDeliveryterms::valueIsValid($deliveryTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistDeliveryterms', is_array($deliveryTerms) ? implode(', ', $deliveryTerms) : var_export($deliveryTerms, true), implode(', ', \EnumType\CodelistDeliveryterms::getValidValues())), __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Get Reference value
     * @return string
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\PrivateDomestic
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($reference) && mb_strlen($reference) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reference) && mb_strlen($reference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get AdvicePhonenumber value
     * @return string
     */
    public function getAdvicePhonenumber()
    {
        return $this->AdvicePhonenumber;
    }
    /**
     * Set AdvicePhonenumber value
     * @param string $advicePhonenumber
     * @return \StructType\PrivateDomestic
     */
    public function setAdvicePhonenumber($advicePhonenumber = null)
    {
        // validation for constraint: string
        if (!is_null($advicePhonenumber) && !is_string($advicePhonenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advicePhonenumber, true), gettype($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($advicePhonenumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($advicePhonenumber) && mb_strlen($advicePhonenumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($advicePhonenumber)), __LINE__);
        }
        $this->AdvicePhonenumber = $advicePhonenumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\PrivateDomestic
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privateDomesticPositionItem) {
            // validation for constraint: itemType
            if (!$privateDomesticPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($privateDomesticPositionItem) ? get_class($privateDomesticPositionItem) : sprintf('%s(%s)', gettype($privateDomesticPositionItem), var_export($privateDomesticPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\PrivateDomestic
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($position) && count($position) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\PrivateDomestic
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Position) && count($this->Position) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Position)), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get ConsigneeReference value
     * @return string|null
     */
    public function getConsigneeReference()
    {
        return $this->ConsigneeReference;
    }
    /**
     * Set ConsigneeReference value
     * @param string $consigneeReference
     * @return \StructType\PrivateDomestic
     */
    public function setConsigneeReference($consigneeReference = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeReference) && !is_string($consigneeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeReference, true), gettype($consigneeReference)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($consigneeReference) && mb_strlen($consigneeReference) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($consigneeReference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($consigneeReference) && mb_strlen($consigneeReference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($consigneeReference)), __LINE__);
        }
        $this->ConsigneeReference = $consigneeReference;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @param string $contactPerson
     * @return \StructType\PrivateDomestic
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contactPerson)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($contactPerson)), __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get Ordertext1 value
     * @return string|null
     */
    public function getOrdertext1()
    {
        return $this->Ordertext1;
    }
    /**
     * Set Ordertext1 value
     * @param string $ordertext1
     * @return \StructType\PrivateDomestic
     */
    public function setOrdertext1($ordertext1 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext1) && !is_string($ordertext1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext1, true), gettype($ordertext1)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext1) && mb_strlen($ordertext1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext1)), __LINE__);
        }
        $this->Ordertext1 = $ordertext1;
        return $this;
    }
    /**
     * Get Ordertext2 value
     * @return string|null
     */
    public function getOrdertext2()
    {
        return $this->Ordertext2;
    }
    /**
     * Set Ordertext2 value
     * @param string $ordertext2
     * @return \StructType\PrivateDomestic
     */
    public function setOrdertext2($ordertext2 = null)
    {
        // validation for constraint: string
        if (!is_null($ordertext2) && !is_string($ordertext2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordertext2, true), gettype($ordertext2)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($ordertext2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ordertext2) && mb_strlen($ordertext2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ordertext2)), __LINE__);
        }
        $this->Ordertext2 = $ordertext2;
        return $this;
    }
    /**
     * Get Invoicetext value
     * @return string|null
     */
    public function getInvoicetext()
    {
        return $this->Invoicetext;
    }
    /**
     * Set Invoicetext value
     * @param string $invoicetext
     * @return \StructType\PrivateDomestic
     */
    public function setInvoicetext($invoicetext = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetext) && !is_string($invoicetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetext, true), gettype($invoicetext)), __LINE__);
        }
        // validation for constraint: maxLength(33)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) > 33) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 33', mb_strlen($invoicetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoicetext) && mb_strlen($invoicetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoicetext)), __LINE__);
        }
        $this->Invoicetext = $invoicetext;
        return $this;
    }
    /**
     * Get ProductReferenceCode value
     * @return string|null
     */
    public function getProductReferenceCode()
    {
        return $this->ProductReferenceCode;
    }
    /**
     * Set ProductReferenceCode value
     * @param string $productReferenceCode
     * @return \StructType\PrivateDomestic
     */
    public function setProductReferenceCode($productReferenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($productReferenceCode) && !is_string($productReferenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productReferenceCode, true), gettype($productReferenceCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($productReferenceCode) && mb_strlen($productReferenceCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($productReferenceCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($productReferenceCode) && mb_strlen($productReferenceCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($productReferenceCode)), __LINE__);
        }
        $this->ProductReferenceCode = $productReferenceCode;
        return $this;
    }
    /**
     * Get GoodsValue value
     * @return float|null
     */
    public function getGoodsValue()
    {
        return $this->GoodsValue;
    }
    /**
     * Set GoodsValue value
     * @param float $goodsValue
     * @return \StructType\PrivateDomestic
     */
    public function setGoodsValue($goodsValue = null)
    {
        // validation for constraint: float
        if (!is_null($goodsValue) && !(is_float($goodsValue) || is_numeric($goodsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($goodsValue, true), gettype($goodsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($goodsValue) && mb_strlen(mb_substr($goodsValue, false !== mb_strpos($goodsValue, '.') ? mb_strpos($goodsValue, '.') + 1 : mb_strlen($goodsValue))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($goodsValue, true), mb_strlen(mb_substr($goodsValue, mb_strpos($goodsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999.99)
        if (!is_null($goodsValue) && $goodsValue > 9999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999.99', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($goodsValue) && $goodsValue < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,9}.[0-9]{2})
        if (!is_null($goodsValue) && !preg_match('/[1-9]{1}[0-9]{0,9}.[0-9]{2}/', $goodsValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,9}.[0-9]{2}', var_export($goodsValue, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($goodsValue) && mb_strlen(preg_replace('/(\D)/', '', $goodsValue)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($goodsValue, true), mb_strlen(preg_replace('/(\D)/', '', $goodsValue))), __LINE__);
        }
        $this->GoodsValue = $goodsValue;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\PrivateDomestic
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: maxInclusive(99.999)
        if (!is_null($volume) && $volume > 99.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.999', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.000)
        if (!is_null($volume) && $volume < 0.000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{3})
        if (!is_null($volume) && !preg_match('/[0-9]{1,2}.[0-9]{3}/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{3}', var_export($volume, true)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get Loadingmeter value
     * @return float|null
     */
    public function getLoadingmeter()
    {
        return $this->Loadingmeter;
    }
    /**
     * Set Loadingmeter value
     * @param float $loadingmeter
     * @return \StructType\PrivateDomestic
     */
    public function setLoadingmeter($loadingmeter = null)
    {
        // validation for constraint: float
        if (!is_null($loadingmeter) && !(is_float($loadingmeter) || is_numeric($loadingmeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadingmeter, true), gettype($loadingmeter)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(mb_substr($loadingmeter, false !== mb_strpos($loadingmeter, '.') ? mb_strpos($loadingmeter, '.') + 1 : mb_strlen($loadingmeter))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($loadingmeter, true), mb_strlen(mb_substr($loadingmeter, mb_strpos($loadingmeter, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99.99)
        if (!is_null($loadingmeter) && $loadingmeter > 99.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99.99', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($loadingmeter) && $loadingmeter < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,2}.[0-9]{2})
        if (!is_null($loadingmeter) && !preg_match('/[0-9]{1,2}.[0-9]{2}/', $loadingmeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,2}.[0-9]{2}', var_export($loadingmeter, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($loadingmeter) && mb_strlen(preg_replace('/(\D)/', '', $loadingmeter)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($loadingmeter, true), mb_strlen(preg_replace('/(\D)/', '', $loadingmeter))), __LINE__);
        }
        $this->Loadingmeter = $loadingmeter;
        return $this;
    }
    /**
     * Get LoadingunitsFP value
     * @return string|null
     */
    public function getLoadingunitsFP()
    {
        return $this->LoadingunitsFP;
    }
    /**
     * Set LoadingunitsFP value
     * @param string $loadingunitsFP
     * @return \StructType\PrivateDomestic
     */
    public function setLoadingunitsFP($loadingunitsFP = null)
    {
        // validation for constraint: string
        if (!is_null($loadingunitsFP) && !is_string($loadingunitsFP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingunitsFP, true), gettype($loadingunitsFP)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($loadingunitsFP) && mb_strlen($loadingunitsFP) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($loadingunitsFP)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loadingunitsFP) && mb_strlen($loadingunitsFP) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loadingunitsFP)), __LINE__);
        }
        $this->LoadingunitsFP = $loadingunitsFP;
        return $this;
    }
    /**
     * Get LoadingunitsGP value
     * @return string|null
     */
    public function getLoadingunitsGP()
    {
        return $this->LoadingunitsGP;
    }
    /**
     * Set LoadingunitsGP value
     * @param string $loadingunitsGP
     * @return \StructType\PrivateDomestic
     */
    public function setLoadingunitsGP($loadingunitsGP = null)
    {
        // validation for constraint: string
        if (!is_null($loadingunitsGP) && !is_string($loadingunitsGP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadingunitsGP, true), gettype($loadingunitsGP)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($loadingunitsGP) && mb_strlen($loadingunitsGP) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($loadingunitsGP)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($loadingunitsGP) && mb_strlen($loadingunitsGP) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($loadingunitsGP)), __LINE__);
        }
        $this->LoadingunitsGP = $loadingunitsGP;
        return $this;
    }
    /**
     * Get Shipping value
     * @return string|null
     */
    public function getShipping()
    {
        return $this->Shipping;
    }
    /**
     * Set Shipping value
     * @uses \EnumType\CodelistShipping::valueIsValid()
     * @uses \EnumType\CodelistShipping::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipping
     * @return \StructType\PrivateDomestic
     */
    public function setShipping($shipping = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistShipping::valueIsValid($shipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistShipping', is_array($shipping) ? implode(', ', $shipping) : var_export($shipping, true), implode(', ', \EnumType\CodelistShipping::getValidValues())), __LINE__);
        }
        $this->Shipping = $shipping;
        return $this;
    }
    /**
     * Get ShippingFreetext value
     * @return string|null
     */
    public function getShippingFreetext()
    {
        return $this->ShippingFreetext;
    }
    /**
     * Set ShippingFreetext value
     * @param string $shippingFreetext
     * @return \StructType\PrivateDomestic
     */
    public function setShippingFreetext($shippingFreetext = null)
    {
        // validation for constraint: string
        if (!is_null($shippingFreetext) && !is_string($shippingFreetext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingFreetext, true), gettype($shippingFreetext)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($shippingFreetext) && mb_strlen($shippingFreetext) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($shippingFreetext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shippingFreetext) && mb_strlen($shippingFreetext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shippingFreetext)), __LINE__);
        }
        $this->ShippingFreetext = $shippingFreetext;
        return $this;
    }
    /**
     * Get DriverAdvice value
     * @return string|null
     */
    public function getDriverAdvice()
    {
        return $this->DriverAdvice;
    }
    /**
     * Set DriverAdvice value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $driverAdvice
     * @return \StructType\PrivateDomestic
     */
    public function setDriverAdvice($driverAdvice = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($driverAdvice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($driverAdvice) ? implode(', ', $driverAdvice) : var_export($driverAdvice, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->DriverAdvice = $driverAdvice;
        return $this;
    }
    /**
     * Get DriverAdviceText value
     * @return string|null
     */
    public function getDriverAdviceText()
    {
        return $this->DriverAdviceText;
    }
    /**
     * Set DriverAdviceText value
     * @param string $driverAdviceText
     * @return \StructType\PrivateDomestic
     */
    public function setDriverAdviceText($driverAdviceText = null)
    {
        // validation for constraint: string
        if (!is_null($driverAdviceText) && !is_string($driverAdviceText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverAdviceText, true), gettype($driverAdviceText)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($driverAdviceText) && mb_strlen($driverAdviceText) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($driverAdviceText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($driverAdviceText) && mb_strlen($driverAdviceText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($driverAdviceText)), __LINE__);
        }
        $this->DriverAdviceText = $driverAdviceText;
        return $this;
    }
    /**
     * Get DeliveryFreeAtPlaceOfUse value
     * @return string|null
     */
    public function getDeliveryFreeAtPlaceOfUse()
    {
        return $this->DeliveryFreeAtPlaceOfUse;
    }
    /**
     * Set DeliveryFreeAtPlaceOfUse value
     * @uses \EnumType\Boolean::valueIsValid()
     * @uses \EnumType\Boolean::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryFreeAtPlaceOfUse
     * @return \StructType\PrivateDomestic
     */
    public function setDeliveryFreeAtPlaceOfUse($deliveryFreeAtPlaceOfUse = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Boolean::valueIsValid($deliveryFreeAtPlaceOfUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Boolean', is_array($deliveryFreeAtPlaceOfUse) ? implode(', ', $deliveryFreeAtPlaceOfUse) : var_export($deliveryFreeAtPlaceOfUse, true), implode(', ', \EnumType\Boolean::getValidValues())), __LINE__);
        }
        $this->DeliveryFreeAtPlaceOfUse = $deliveryFreeAtPlaceOfUse;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return float|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param float $cashOnDelivery
     * @return \StructType\PrivateDomestic
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: float
        if (!is_null($cashOnDelivery) && !(is_float($cashOnDelivery) || is_numeric($cashOnDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cashOnDelivery) && mb_strlen(mb_substr($cashOnDelivery, false !== mb_strpos($cashOnDelivery, '.') ? mb_strpos($cashOnDelivery, '.') + 1 : mb_strlen($cashOnDelivery))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cashOnDelivery, true), mb_strlen(mb_substr($cashOnDelivery, mb_strpos($cashOnDelivery, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999.99)
        if (!is_null($cashOnDelivery) && $cashOnDelivery > 9999999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999.99', var_export($cashOnDelivery, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($cashOnDelivery) && $cashOnDelivery < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($cashOnDelivery, true)), __LINE__);
        }
        // validation for constraint: pattern([1-9]{1}[0-9]{0,9}.[0-9]{2})
        if (!is_null($cashOnDelivery) && !preg_match('/[1-9]{1}[0-9]{0,9}.[0-9]{2}/', $cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]{1}[0-9]{0,9}.[0-9]{2}', var_export($cashOnDelivery, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($cashOnDelivery) && mb_strlen(preg_replace('/(\D)/', '', $cashOnDelivery)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($cashOnDelivery, true), mb_strlen(preg_replace('/(\D)/', '', $cashOnDelivery))), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get TermsOfPayment value
     * @return string|null
     */
    public function getTermsOfPayment()
    {
        return $this->TermsOfPayment;
    }
    /**
     * Set TermsOfPayment value
     * @uses \EnumType\CodelistTermsPayment::valueIsValid()
     * @uses \EnumType\CodelistTermsPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $termsOfPayment
     * @return \StructType\PrivateDomestic
     */
    public function setTermsOfPayment($termsOfPayment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodelistTermsPayment::valueIsValid($termsOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CodelistTermsPayment', is_array($termsOfPayment) ? implode(', ', $termsOfPayment) : var_export($termsOfPayment, true), implode(', ', \EnumType\CodelistTermsPayment::getValidValues())), __LINE__);
        }
        $this->TermsOfPayment = $termsOfPayment;
        return $this;
    }
}
